/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.config.properties.HaloProperties;
import run.halo.app.event.StaticStorageChangedEvent;
import run.halo.app.exception.FileOperationException;
import run.halo.app.exception.ServiceException;
import run.halo.app.model.support.StaticFile;
import run.halo.app.service.StaticStorageService;
import run.halo.app.utils.FileUtils;
import run.halo.app.utils.HaloUtils;

@Service
public class StaticStorageServiceImpl
implements StaticStorageService,
ApplicationListener<ApplicationStartedEvent> {
    private static final Logger log = LoggerFactory.getLogger(StaticStorageServiceImpl.class);
    private final Path staticDir;
    private final ApplicationEventPublisher eventPublisher;

    public StaticStorageServiceImpl(HaloProperties haloProperties, ApplicationEventPublisher eventPublisher) throws IOException {
        this.staticDir = Paths.get(haloProperties.getWorkDir(), "static");
        this.eventPublisher = eventPublisher;
        FileUtils.createIfAbsent((Path)this.staticDir);
    }

    public List<StaticFile> listStaticFolder() {
        return this.listStaticFileTree(this.staticDir);
    }

    @Nullable
    private List<StaticFile> listStaticFileTree(@NonNull Path topPath) {
        LinkedList<StaticFile> linkedList;
        block9: {
            Assert.notNull((Object)topPath, (String)"Top path must not be null");
            if (!Files.isDirectory(topPath, new LinkOption[0])) {
                return null;
            }
            Stream<Path> pathStream = Files.list(topPath);
            try {
                LinkedList<StaticFile> staticFiles = new LinkedList<StaticFile>();
                pathStream.forEach(path -> {
                    StaticFile staticFile = new StaticFile();
                    staticFile.setId(HaloUtils.simpleUUID());
                    staticFile.setName(path.getFileName().toString());
                    staticFile.setPath(path.toString());
                    staticFile.setRelativePath(StringUtils.removeStart((String)path.toString(), (String)this.staticDir.toString()));
                    staticFile.setIsFile(Boolean.valueOf(Files.isRegularFile(path, new LinkOption[0])));
                    try {
                        staticFile.setCreateTime(Long.valueOf(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis()));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    staticFile.setMimeType(MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(path.toFile()));
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        staticFile.setChildren(this.listStaticFileTree(path));
                    }
                    staticFiles.add(staticFile);
                });
                staticFiles.sort((Comparator<StaticFile>)new StaticFile());
                linkedList = staticFiles;
                if (pathStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ServiceException("Failed to list sub files", (Throwable)e);
                }
            }
            pathStream.close();
        }
        return linkedList;
    }

    public void delete(String relativePath) {
        Assert.notNull((Object)relativePath, (String)"Relative path must not be null");
        Path path = Paths.get(this.staticDir.toString(), relativePath);
        FileUtils.checkDirectoryTraversal((String)this.staticDir.toString(), (String)path.toString());
        log.debug(path.toString());
        try {
            if (path.toFile().isDirectory()) {
                FileUtils.deleteFolder((Path)path);
            } else {
                Files.deleteIfExists(path);
            }
            this.onChange();
        }
        catch (IOException e) {
            throw new FileOperationException("\u6587\u4ef6 " + relativePath + " \u5220\u9664\u5931\u8d25", (Throwable)e);
        }
    }

    public void createFolder(String basePath, String folderName) {
        Assert.notNull((Object)folderName, (String)"Folder name path must not be null");
        if (StringUtils.startsWith((CharSequence)folderName, (CharSequence)"api")) {
            throw new FileOperationException("\u76ee\u5f55\u540d\u79f0 " + folderName + " \u4e0d\u5408\u6cd5");
        }
        Path path = StringUtils.isEmpty((CharSequence)basePath) ? Paths.get(this.staticDir.toString(), folderName) : Paths.get(this.staticDir.toString(), basePath, folderName);
        FileUtils.checkDirectoryTraversal((String)this.staticDir.toString(), (String)path.toString());
        if (path.toFile().exists()) {
            throw new FileOperationException("\u76ee\u5f55 " + path.toString() + " \u5df2\u5b58\u5728").setErrorData((Object)path);
        }
        try {
            FileUtils.createIfAbsent((Path)path);
        }
        catch (IOException e) {
            throw new FileOperationException("\u76ee\u5f55 " + path.toString() + " \u521b\u5efa\u5931\u8d25", (Throwable)e);
        }
    }

    public void upload(String basePath, MultipartFile file) {
        Assert.notNull((Object)file, (String)"Multipart file must not be null");
        if (StringUtils.startsWith((CharSequence)file.getOriginalFilename(), (CharSequence)"api")) {
            throw new FileOperationException("\u6587\u4ef6\u540d\u79f0 " + file.getOriginalFilename() + " \u4e0d\u5408\u6cd5");
        }
        Path uploadPath = StringUtils.isEmpty((CharSequence)basePath) ? Paths.get(this.staticDir.toString(), file.getOriginalFilename()) : Paths.get(this.staticDir.toString(), basePath, file.getOriginalFilename());
        FileUtils.checkDirectoryTraversal((String)this.staticDir.toString(), (String)uploadPath.toString());
        if (uploadPath.toFile().exists()) {
            throw new FileOperationException("\u6587\u4ef6 " + file.getOriginalFilename() + " \u5df2\u5b58\u5728").setErrorData((Object)uploadPath);
        }
        try {
            Files.createFile(uploadPath, new FileAttribute[0]);
            file.transferTo(uploadPath);
            this.onChange();
        }
        catch (IOException e) {
            throw new ServiceException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25").setErrorData((Object)uploadPath);
        }
    }

    public void rename(String basePath, String newName) {
        Assert.notNull((Object)basePath, (String)"Base path must not be null");
        Assert.notNull((Object)newName, (String)"New name must not be null");
        if (StringUtils.startsWith((CharSequence)newName, (CharSequence)"api")) {
            throw new FileOperationException("\u91cd\u547d\u540d\u540d\u79f0 " + newName + " \u4e0d\u5408\u6cd5");
        }
        Path pathToRename = Paths.get(this.staticDir.toString(), basePath);
        FileUtils.checkDirectoryTraversal((String)this.staticDir.toString(), (String)pathToRename.toString());
        try {
            FileUtils.rename((Path)pathToRename, (String)newName);
            this.onChange();
        }
        catch (FileAlreadyExistsException e) {
            throw new FileOperationException("\u8be5\u8def\u5f84\u4e0b\u540d\u79f0 " + newName + " \u5df2\u5b58\u5728");
        }
        catch (IOException e) {
            throw new FileOperationException("\u91cd\u547d\u540d " + pathToRename.toString() + " \u5931\u8d25");
        }
    }

    public void save(String path, String content) {
        Assert.notNull((Object)path, (String)"Path must not be null");
        Path savePath = Paths.get(this.staticDir.toString(), path);
        FileUtils.checkDirectoryTraversal((String)this.staticDir.toString(), (String)savePath.toString());
        if (!Files.isRegularFile(savePath, new LinkOption[0])) {
            throw new FileOperationException("\u8def\u5f84 " + path + " \u4e0d\u5408\u6cd5");
        }
        try {
            Files.write(savePath, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ServiceException("\u4fdd\u5b58\u5185\u5bb9\u5931\u8d25 " + path, (Throwable)e);
        }
    }

    private void onChange() {
        this.eventPublisher.publishEvent((ApplicationEvent)new StaticStorageChangedEvent((Object)this, this.staticDir));
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        this.onChange();
    }
}

