/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import org.springframework.stereotype.Service;
import run.halo.app.exception.ServiceException;
import run.halo.app.model.dto.StatisticDTO;
import run.halo.app.model.dto.StatisticWithUserDTO;
import run.halo.app.model.dto.UserDTO;
import run.halo.app.model.entity.User;
import run.halo.app.model.enums.CommentStatus;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.service.CategoryService;
import run.halo.app.service.JournalCommentService;
import run.halo.app.service.JournalService;
import run.halo.app.service.LinkService;
import run.halo.app.service.OptionService;
import run.halo.app.service.PostCommentService;
import run.halo.app.service.PostService;
import run.halo.app.service.SheetCommentService;
import run.halo.app.service.SheetService;
import run.halo.app.service.StatisticService;
import run.halo.app.service.TagService;
import run.halo.app.service.UserService;

@Service
public class StatisticServiceImpl
implements StatisticService {
    private final PostService postService;
    private final SheetService sheetService;
    private final JournalService journalService;
    private final PostCommentService postCommentService;
    private final SheetCommentService sheetCommentService;
    private final JournalCommentService journalCommentService;
    private final OptionService optionService;
    private final LinkService linkService;
    private final CategoryService categoryService;
    private final TagService tagService;
    private final UserService userService;

    public StatisticServiceImpl(PostService postService, SheetService sheetService, JournalService journalService, PostCommentService postCommentService, SheetCommentService sheetCommentService, JournalCommentService journalCommentService, OptionService optionService, LinkService linkService, CategoryService categoryService, TagService tagService, UserService userService) {
        this.postService = postService;
        this.sheetService = sheetService;
        this.journalService = journalService;
        this.postCommentService = postCommentService;
        this.sheetCommentService = sheetCommentService;
        this.journalCommentService = journalCommentService;
        this.optionService = optionService;
        this.linkService = linkService;
        this.categoryService = categoryService;
        this.tagService = tagService;
        this.userService = userService;
    }

    public StatisticDTO getStatistic() {
        StatisticDTO statisticDto = new StatisticDTO();
        statisticDto.setPostCount(Long.valueOf(this.postService.countByStatus(PostStatus.PUBLISHED)));
        long postCommentCount = this.postCommentService.countByStatus(CommentStatus.PUBLISHED);
        long sheetCommentCount = this.sheetCommentService.countByStatus(CommentStatus.PUBLISHED);
        long journalCommentCount = this.journalCommentService.countByStatus(CommentStatus.PUBLISHED);
        statisticDto.setCommentCount(Long.valueOf(postCommentCount + sheetCommentCount + journalCommentCount));
        statisticDto.setTagCount(Long.valueOf(this.tagService.count()));
        statisticDto.setCategoryCount(Long.valueOf(this.categoryService.count()));
        statisticDto.setJournalCount(Long.valueOf(this.journalService.count()));
        long birthday = this.optionService.getBirthday();
        long days = (System.currentTimeMillis() - birthday) / 86400000L;
        statisticDto.setEstablishDays(Long.valueOf(days));
        statisticDto.setBirthday(Long.valueOf(birthday));
        statisticDto.setLinkCount(Long.valueOf(this.linkService.count()));
        statisticDto.setVisitCount(Long.valueOf(this.postService.countVisit() + this.sheetService.countVisit()));
        statisticDto.setLikeCount(Long.valueOf(this.postService.countLike() + this.sheetService.countLike()));
        return statisticDto;
    }

    public StatisticWithUserDTO getStatisticWithUser() {
        StatisticDTO statisticDto = this.getStatistic();
        StatisticWithUserDTO statisticWithUserDto = new StatisticWithUserDTO();
        statisticWithUserDto.convertFrom((Object)statisticDto);
        User user = (User)this.userService.getCurrentUser().orElseThrow(() -> new ServiceException("\u672a\u67e5\u8be2\u5230\u535a\u4e3b\u4fe1\u606f"));
        statisticWithUserDto.setUser((UserDTO)new UserDTO().convertFrom((Object)user));
        return statisticWithUserDto;
    }
}

