/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.exception.AlreadyExistsException;
import run.halo.app.exception.NotFoundException;
import run.halo.app.model.dto.TagDTO;
import run.halo.app.model.entity.Tag;
import run.halo.app.repository.TagRepository;
import run.halo.app.repository.base.BaseRepository;
import run.halo.app.service.OptionService;
import run.halo.app.service.TagService;
import run.halo.app.service.base.AbstractCrudService;

@Service
public class TagServiceImpl
extends AbstractCrudService<Tag, Integer>
implements TagService {
    private static final Logger log = LoggerFactory.getLogger(TagServiceImpl.class);
    private final TagRepository tagRepository;
    private final OptionService optionService;

    public TagServiceImpl(TagRepository tagRepository, OptionService optionService) {
        super((BaseRepository)tagRepository);
        this.tagRepository = tagRepository;
        this.optionService = optionService;
    }

    @Transactional
    public Tag create(Tag tag) {
        long count = this.tagRepository.countByNameOrSlug(tag.getName(), tag.getSlug());
        log.debug("Tag count: [{}]", (Object)count);
        if (count > 0L) {
            throw new AlreadyExistsException("\u8be5\u6807\u7b7e\u5df2\u5b58\u5728").setErrorData((Object)tag);
        }
        return (Tag)super.create((Object)tag);
    }

    public Tag getBySlugOfNonNull(String slug) {
        return (Tag)this.tagRepository.getBySlug(slug).orElseThrow(() -> new NotFoundException("\u67e5\u8be2\u4e0d\u5230\u8be5\u6807\u7b7e\u7684\u4fe1\u606f").setErrorData((Object)slug));
    }

    public Tag getBySlug(String slug) {
        return this.tagRepository.getBySlug(slug).orElse(null);
    }

    public Tag getByName(String name) {
        return this.tagRepository.getByName(name).orElse(null);
    }

    public TagDTO convertTo(Tag tag) {
        Assert.notNull((Object)tag, (String)"Tag must not be null");
        TagDTO tagDTO = (TagDTO)new TagDTO().convertFrom((Object)tag);
        StringBuilder fullPath = new StringBuilder();
        if (this.optionService.isEnabledAbsolutePath().booleanValue()) {
            fullPath.append(this.optionService.getBlogBaseUrl());
        }
        fullPath.append("/").append(this.optionService.getTagsPrefix()).append("/").append(tag.getSlug()).append(this.optionService.getPathSuffix());
        tagDTO.setFullPath(fullPath.toString());
        return tagDTO;
    }

    public List<TagDTO> convertTo(List<Tag> tags) {
        if (CollectionUtils.isEmpty(tags)) {
            return Collections.emptyList();
        }
        return tags.stream().map(arg_0 -> this.convertTo(arg_0)).collect(Collectors.toList());
    }
}

