/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.config.properties.HaloProperties;
import run.halo.app.event.theme.ThemeActivatedEvent;
import run.halo.app.event.theme.ThemeUpdatedEvent;
import run.halo.app.exception.BadRequestException;
import run.halo.app.exception.NotFoundException;
import run.halo.app.exception.ServiceException;
import run.halo.app.exception.ThemeNotFoundException;
import run.halo.app.exception.ThemeNotSupportException;
import run.halo.app.exception.ThemePropertyMissingException;
import run.halo.app.exception.ThemeUpdateException;
import run.halo.app.handler.theme.config.ThemeConfigResolver;
import run.halo.app.handler.theme.config.support.Group;
import run.halo.app.handler.theme.config.support.Item;
import run.halo.app.handler.theme.config.support.ThemeProperty;
import run.halo.app.model.support.ThemeFile;
import run.halo.app.repository.ThemeRepository;
import run.halo.app.repository.ThemeSettingRepository;
import run.halo.app.service.ThemeService;
import run.halo.app.theme.GitThemeFetcher;
import run.halo.app.theme.GitThemeUpdater;
import run.halo.app.theme.MultipartFileThemeUpdater;
import run.halo.app.theme.MultipartZipFileThemeFetcher;
import run.halo.app.theme.ThemeFetcher;
import run.halo.app.theme.ThemeFetcherComposite;
import run.halo.app.theme.ThemeFileScanner;
import run.halo.app.theme.ThemePropertyScanner;
import run.halo.app.theme.ZipThemeFetcher;
import run.halo.app.utils.FileUtils;

@Service
public class ThemeServiceImpl
implements ThemeService {
    private static final Logger log = LoggerFactory.getLogger(ThemeServiceImpl.class);
    private final Path themeWorkDir;
    private final ThemeConfigResolver themeConfigResolver;
    private final RestTemplate restTemplate;
    private final ApplicationEventPublisher eventPublisher;
    private final ThemeSettingRepository themeSettingRepository;
    private final ThemeFetcherComposite fetcherComposite;
    private final ThemeRepository themeRepository;

    public ThemeServiceImpl(HaloProperties haloProperties, ThemeConfigResolver themeConfigResolver, RestTemplate restTemplate, ApplicationEventPublisher eventPublisher, ThemeSettingRepository themeSettingRepository, ThemeRepository themeRepository) {
        this.themeConfigResolver = themeConfigResolver;
        this.restTemplate = restTemplate;
        this.themeWorkDir = Paths.get(haloProperties.getWorkDir(), "templates/themes");
        this.eventPublisher = eventPublisher;
        this.themeSettingRepository = themeSettingRepository;
        this.themeRepository = themeRepository;
        this.fetcherComposite = new ThemeFetcherComposite();
        this.fetcherComposite.addFetcher((ThemeFetcher)new ZipThemeFetcher());
        this.fetcherComposite.addFetcher((ThemeFetcher)new GitThemeFetcher());
        this.fetcherComposite.addFetcher((ThemeFetcher)new MultipartZipFileThemeFetcher());
    }

    @NonNull
    public ThemeProperty getThemeOfNonNullBy(@NonNull String themeId) {
        return (ThemeProperty)this.fetchThemePropertyBy(themeId).orElseThrow(() -> new NotFoundException(themeId + " \u4e3b\u9898\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01").setErrorData((Object)themeId));
    }

    @NonNull
    public Optional<ThemeProperty> fetchThemePropertyBy(String themeId) {
        return this.themeRepository.fetchThemePropertyByThemeId(themeId);
    }

    @NonNull
    public List<ThemeProperty> getThemes() {
        return this.themeRepository.listAll();
    }

    @NonNull
    public List<ThemeFile> listThemeFolderBy(@NonNull String themeId) {
        return this.fetchThemePropertyBy(themeId).map(themeProperty -> ThemeFileScanner.INSTANCE.scan(themeProperty.getThemePath())).orElse(Collections.emptyList());
    }

    @NonNull
    public List<String> listCustomTemplates(@NonNull String themeId, @NonNull String prefix) {
        return this.fetchThemePropertyBy(themeId).map(themeProperty -> {
            List list;
            block8: {
                Path themePath = Paths.get(themeProperty.getThemePath(), new String[0]);
                Stream<Path> pathStream = Files.list(themePath);
                try {
                    list = pathStream.filter(path -> StringUtils.startsWithIgnoreCase((CharSequence)path.getFileName().toString(), (CharSequence)prefix)).map(path -> {
                        String customTemplate = StringUtils.removeStartIgnoreCase((String)path.getFileName().toString(), (String)prefix);
                        return StringUtils.removeEndIgnoreCase((String)customTemplate, (String)".ftl");
                    }).distinct().collect(Collectors.toList());
                    if (pathStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (pathStream != null) {
                            try {
                                pathStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new ServiceException("Failed to list files of path " + themePath, (Throwable)e);
                    }
                }
                pathStream.close();
            }
            return list;
        }).orElse(Collections.emptyList());
    }

    public boolean templateExists(String template) {
        if (StringUtils.isBlank((CharSequence)template)) {
            return false;
        }
        return this.fetchActivatedTheme().map(themeProperty -> {
            Path templatePath = Paths.get(themeProperty.getThemePath(), template);
            this.checkDirectory(templatePath.toString());
            return Files.exists(templatePath, new LinkOption[0]);
        }).orElse(false);
    }

    public boolean themeExists(String themeId) {
        return this.fetchThemePropertyBy(themeId).isPresent();
    }

    public Path getBasePath() {
        return this.themeWorkDir;
    }

    public String getTemplateContent(@NonNull String absolutePath) {
        this.checkDirectory(absolutePath);
        Path path = Paths.get(absolutePath, new String[0]);
        try {
            return Files.readString(path);
        }
        catch (IOException e) {
            throw new ServiceException("\u8bfb\u53d6\u6a21\u677f\u5185\u5bb9\u5931\u8d25 " + absolutePath, (Throwable)e);
        }
    }

    @NonNull
    public String getTemplateContent(@NonNull String themeId, @NonNull String absolutePath) {
        this.checkDirectory(themeId, absolutePath);
        Path path = Paths.get(absolutePath, new String[0]);
        try {
            return Files.readString(path);
        }
        catch (IOException e) {
            throw new ServiceException("\u8bfb\u53d6\u6a21\u677f\u5185\u5bb9\u5931\u8d25 " + absolutePath, (Throwable)e);
        }
    }

    public void saveTemplateContent(@NonNull String absolutePath, String content) {
        this.checkDirectory(absolutePath);
        Path path = Paths.get(absolutePath, new String[0]);
        try {
            Files.write(path, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ServiceException("\u4fdd\u5b58\u6a21\u677f\u5185\u5bb9\u5931\u8d25 " + absolutePath, (Throwable)e);
        }
    }

    public void saveTemplateContent(@NonNull String themeId, @NonNull String absolutePath, String content) {
        this.checkDirectory(themeId, absolutePath);
        Path path = Paths.get(absolutePath, new String[0]);
        try {
            Files.write(path, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ServiceException("\u4fdd\u5b58\u6a21\u677f\u5185\u5bb9\u5931\u8d25 " + absolutePath, (Throwable)e);
        }
    }

    @Transactional
    public void deleteTheme(@NonNull String themeId, @NonNull Boolean deleteSettings) {
        ThemeProperty themeProperty = this.getThemeOfNonNullBy(themeId);
        if (themeId.equals(this.getActivatedThemeId())) {
            throw new BadRequestException("\u65e0\u6cd5\u5220\u9664\u6b63\u5728\u4f7f\u7528\u7684\u4e3b\u9898\uff01").setErrorData((Object)themeId);
        }
        try {
            FileUtils.deleteFolder((Path)Paths.get(themeProperty.getThemePath(), new String[0]));
            if (deleteSettings.booleanValue()) {
                this.themeSettingRepository.deleteByThemeId(themeId);
            }
            this.eventPublisher.publishEvent((ApplicationEvent)new ThemeUpdatedEvent((Object)this));
        }
        catch (Exception e) {
            throw new ServiceException("\u4e3b\u9898\u5220\u9664\u5931\u8d25", (Throwable)e).setErrorData((Object)themeId);
        }
    }

    @NonNull
    public List<Group> fetchConfig(@NonNull String themeId) {
        Assert.hasText((String)themeId, (String)"Theme id must not be blank");
        ThemeProperty themeProperty = this.getThemeOfNonNullBy(themeId);
        if (!themeProperty.isHasOptions()) {
            return Collections.emptyList();
        }
        try {
            for (String optionsName : SETTINGS_NAMES) {
                Path optionsPath = Paths.get(themeProperty.getThemePath(), optionsName);
                log.debug("Finding options in: [{}]", (Object)optionsPath.toString());
                if (!Files.exists(optionsPath, new LinkOption[0])) continue;
                String optionContent = Files.readString(optionsPath);
                return this.themeConfigResolver.resolve(optionContent);
            }
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw new ServiceException("\u8bfb\u53d6\u4e3b\u9898\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    public Set<Item> fetchConfigItemsBy(@NonNull String themeId, @NonNull String group) {
        return this.fetchConfig(themeId).stream().filter(g -> StringUtils.equals((CharSequence)g.getName(), (CharSequence)group)).findFirst().map(Group::getItems).map(items -> new LinkedHashSet(items)).orElseGet(Collections::emptySet);
    }

    public String render(String pageName) {
        String folderName = this.getActivatedTheme().getFolderName();
        return "themes/" + folderName + "/" + pageName;
    }

    public String renderWithSuffix(String pageName) {
        String folderName = this.getActivatedTheme().getFolderName();
        return "themes/" + folderName + "/" + pageName + ".ftl";
    }

    @NonNull
    public String getActivatedThemeId() {
        return this.themeRepository.getActivatedThemeId();
    }

    @NonNull
    public ThemeProperty getActivatedTheme() {
        return this.themeRepository.getActivatedThemeProperty();
    }

    @NonNull
    public Optional<ThemeProperty> fetchActivatedTheme() {
        try {
            return Optional.of(this.themeRepository.getActivatedThemeProperty());
        }
        catch (ThemeNotFoundException tne) {
            return Optional.empty();
        }
    }

    @NonNull
    public ThemeProperty activateTheme(@NonNull String themeId) {
        this.themeRepository.setActivatedTheme(themeId);
        this.eventPublisher.publishEvent((ApplicationEvent)new ThemeUpdatedEvent((Object)this));
        this.eventPublisher.publishEvent((ApplicationEvent)new ThemeActivatedEvent((Object)this));
        return this.themeRepository.getActivatedThemeProperty();
    }

    @NonNull
    public ThemeProperty upload(@NonNull MultipartFile file) {
        Assert.notNull((Object)file, (String)"Multipart file must not be null");
        ThemeProperty newThemeProperty = this.fetcherComposite.fetch((Object)file);
        return this.themeRepository.attemptToAdd(newThemeProperty);
    }

    public ThemeProperty fetch(@NonNull String uri) {
        Assert.hasText((String)uri, (String)"Theme remote uri must not be blank");
        ThemeProperty themeProperty = this.fetcherComposite.fetch((Object)uri);
        return this.themeRepository.attemptToAdd(themeProperty);
    }

    public void reload() {
        this.eventPublisher.publishEvent((ApplicationEvent)new ThemeUpdatedEvent((Object)this));
    }

    public ThemeProperty update(String themeId) {
        GitThemeUpdater themeUpdater = new GitThemeUpdater(this.themeRepository, this.fetcherComposite);
        Assert.hasText((String)themeId, (String)"Theme id must not be blank");
        try {
            ThemeProperty themeProperty = themeUpdater.update(themeId);
        }
        catch (Exception e) {
            if (e instanceof ThemeNotSupportException) {
                throw (ThemeNotSupportException)e;
            }
            throw new ThemeUpdateException("\u4e3b\u9898\u66f4\u65b0\u5931\u8d25\uff01", (Throwable)e).setErrorData((Object)themeId);
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new ThemeUpdatedEvent((Object)this));
        return this.getThemeOfNonNullBy(themeId);
    }

    public ThemeProperty update(String themeId, MultipartFile file) {
        Assert.hasText((String)themeId, (String)"Theme id must not be blank");
        Assert.notNull((Object)file, (String)"Theme file must not be null");
        MultipartFileThemeUpdater themeUpdater = new MultipartFileThemeUpdater(file, this.fetcherComposite, this.themeRepository);
        try {
            return themeUpdater.update(themeId);
        }
        catch (IOException e) {
            throw new ServiceException("\u66f4\u65b0\u4e3b\u9898\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    private void downloadZipAndUnzip(@NonNull String zipUrl, @NonNull Path targetPath) throws IOException {
        Assert.hasText((String)zipUrl, (String)"Zip url must not be blank");
        log.debug("Downloading [{}]", (Object)zipUrl);
        ResponseEntity downloadResponse = this.restTemplate.getForEntity(zipUrl, byte[].class, new Object[0]);
        log.debug("Download response: [{}]", (Object)downloadResponse.getStatusCode());
        if (downloadResponse.getStatusCode().isError() || downloadResponse.getBody() == null) {
            throw new ServiceException("\u4e0b\u8f7d\u5931\u8d25 " + zipUrl + ", \u72b6\u6001\u7801: " + downloadResponse.getStatusCode());
        }
        log.debug("Downloaded [{}]", (Object)zipUrl);
        FileUtils.unzip((byte[])((byte[])downloadResponse.getBody()), (Path)targetPath);
    }

    private void checkDirectory(@NonNull String absoluteName) {
        ThemeProperty activeThemeProperty = this.getThemeOfNonNullBy(this.getActivatedThemeId());
        FileUtils.checkDirectoryTraversal((String)activeThemeProperty.getThemePath(), (String)absoluteName);
    }

    private void checkDirectory(@NonNull String themeId, @NonNull String absoluteName) {
        ThemeProperty themeProperty = this.getThemeOfNonNullBy(themeId);
        FileUtils.checkDirectoryTraversal((String)themeProperty.getThemePath(), (String)absoluteName);
    }

    @NonNull
    private ThemeProperty getProperty(@NonNull Path themePath) {
        return (ThemeProperty)ThemePropertyScanner.INSTANCE.fetchThemeProperty(themePath).orElseThrow(() -> new ThemePropertyMissingException(themePath + " \u6ca1\u6709\u8bf4\u660e\u6587\u4ef6").setErrorData((Object)themePath));
    }
}

