/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import freemarker.template.Configuration;
import freemarker.template.TemplateModelException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Example;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.exception.ServiceException;
import run.halo.app.handler.theme.config.support.Item;
import run.halo.app.model.entity.ThemeSetting;
import run.halo.app.repository.ThemeSettingRepository;
import run.halo.app.repository.base.BaseRepository;
import run.halo.app.service.ThemeService;
import run.halo.app.service.ThemeSettingService;
import run.halo.app.service.base.AbstractCrudService;
import run.halo.app.utils.ServiceUtils;

@Service
public class ThemeSettingServiceImpl
extends AbstractCrudService<ThemeSetting, Integer>
implements ThemeSettingService {
    private static final Logger log = LoggerFactory.getLogger(ThemeSettingServiceImpl.class);
    private final ThemeSettingRepository themeSettingRepository;
    private final ThemeService themeService;
    private final Configuration configuration;

    public ThemeSettingServiceImpl(ThemeSettingRepository themeSettingRepository, ThemeService themeService, Configuration configuration) {
        super((BaseRepository)themeSettingRepository);
        this.themeSettingRepository = themeSettingRepository;
        this.themeService = themeService;
        this.configuration = configuration;
    }

    public ThemeSetting save(String key, String value, String themeId) {
        Assert.notNull((Object)key, (String)"Setting key must not be null");
        this.assertThemeIdHasText(themeId);
        log.debug("Starting saving theme setting key: [{}], value: [{}]", (Object)key, (Object)value);
        Optional themeSettingOptional = this.themeSettingRepository.findByThemeIdAndKey(themeId, key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return themeSettingOptional.map(setting -> {
                this.themeSettingRepository.delete(setting);
                log.debug("Removed theme setting: [{}]", setting);
                return setting;
            }).orElse(null);
        }
        Map itemMap = this.getConfigItemMap(themeId);
        Item item = (Item)itemMap.get(key);
        ThemeSetting themeSetting = themeSettingOptional.map(setting -> {
            log.debug("Updating theme setting: [{}]", setting);
            setting.setValue(value);
            log.debug("Updated theme setting: [{}]", setting);
            return setting;
        }).orElseGet(() -> {
            ThemeSetting setting = new ThemeSetting();
            setting.setKey(key);
            setting.setValue(value);
            setting.setThemeId(themeId);
            log.debug("Creating theme setting: [{}]", (Object)setting);
            return setting;
        });
        if (this.themeSettingRepository.findOne(Example.of((Object)themeSetting)).isPresent()) {
            return null;
        }
        return (ThemeSetting)this.themeSettingRepository.save((Object)themeSetting);
    }

    public void save(Map<String, Object> settings, String themeId) {
        this.assertThemeIdHasText(themeId);
        if (CollectionUtils.isEmpty(settings)) {
            return;
        }
        settings.forEach((key, value) -> this.save(key, value.toString(), themeId));
        try {
            this.configuration.setSharedVariable("settings", (Object)this.listAsMapBy(this.themeService.getActivatedThemeId()));
        }
        catch (TemplateModelException e) {
            throw new ServiceException("\u4e3b\u9898\u8bbe\u7f6e\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    @NonNull
    public List<ThemeSetting> listBy(String themeId) {
        this.assertThemeIdHasText(themeId);
        return this.themeSettingRepository.findAllByThemeId(themeId);
    }

    @NonNull
    public Map<String, Object> listAsMapBy(@NonNull String themeId) {
        Map itemMap = this.getConfigItemMap(themeId);
        return this.listAsMapBy(themeId, itemMap);
    }

    @NonNull
    public Map<String, Object> listAsMapBy(String themeId, String group) {
        Set items = this.themeService.fetchConfigItemsBy(themeId, group);
        Map itemMap = ServiceUtils.convertToMap((Collection)items, Item::getName);
        return this.listAsMapBy(themeId, itemMap);
    }

    @NotNull
    private Map<String, Object> listAsMapBy(String themeId, Map<String, Item> itemMap) {
        Assert.notNull((Object)themeId, (String)"The themeId must not be null.");
        Assert.notNull(itemMap, (String)"The itemMap must not be null.");
        List themeSettings = this.listBy(themeId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        themeSettings.forEach(themeSetting -> {
            String key = themeSetting.getKey();
            Item item = (Item)itemMap.get(key);
            if (item == null) {
                return;
            }
            Object convertedValue = item.getDataType().convertTo((Object)themeSetting.getValue());
            log.debug("Converted user-defined data from [{}] to [{}], type: [{}]", new Object[]{themeSetting.getValue(), convertedValue, item.getDataType()});
            result.put(key, convertedValue);
        });
        itemMap.forEach((name, item) -> {
            log.debug("Name: [{}], item: [{}]", name, item);
            if (item.getDefaultValue() == null || result.containsKey(name)) {
                return;
            }
            Object convertedDefaultValue = item.getDataType().convertTo(item.getDefaultValue());
            log.debug("Converted pre-defined data from [{}] to [{}], type: [{}]", new Object[]{item.getDefaultValue(), convertedDefaultValue, item.getDataType()});
            result.put((String)name, convertedDefaultValue);
        });
        return result;
    }

    @Transactional
    public void deleteInactivated() {
        this.themeSettingRepository.deleteByThemeIdIsNot(this.themeService.getActivatedThemeId());
    }

    private Map<String, Item> getConfigItemMap(@NonNull String themeId) {
        List groups = this.themeService.fetchConfig(themeId);
        LinkedHashSet items = new LinkedHashSet();
        groups.forEach(group -> items.addAll(group.getItems()));
        return ServiceUtils.convertToMap(items, Item::getName);
    }

    private void assertThemeIdHasText(String themeId) {
        Assert.hasText((String)themeId, (String)"Theme id must not be null");
    }
}

