/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.service.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.cache.lock.CacheLock;
import run.halo.app.event.logger.LogEvent;
import run.halo.app.event.user.UserUpdatedEvent;
import run.halo.app.exception.BadRequestException;
import run.halo.app.exception.ForbiddenException;
import run.halo.app.exception.NotFoundException;
import run.halo.app.exception.ServiceException;
import run.halo.app.model.entity.User;
import run.halo.app.model.enums.LogType;
import run.halo.app.model.enums.MFAType;
import run.halo.app.model.params.UserParam;
import run.halo.app.repository.UserRepository;
import run.halo.app.repository.base.BaseRepository;
import run.halo.app.service.UserService;
import run.halo.app.service.base.AbstractCrudService;
import run.halo.app.utils.BCrypt;
import run.halo.app.utils.DateUtils;
import run.halo.app.utils.HaloUtils;

@Service
public class UserServiceImpl
extends AbstractCrudService<User, Integer>
implements UserService {
    private final UserRepository userRepository;
    private final ApplicationEventPublisher eventPublisher;

    public UserServiceImpl(UserRepository userRepository, ApplicationEventPublisher eventPublisher) {
        super((BaseRepository)userRepository);
        this.userRepository = userRepository;
        this.eventPublisher = eventPublisher;
    }

    public Optional<User> getCurrentUser() {
        List users = this.listAll();
        if (CollectionUtils.isEmpty((Collection)users)) {
            return Optional.empty();
        }
        return Optional.of((User)users.get(0));
    }

    public Optional<User> getByUsername(String username) {
        return this.userRepository.findByUsername(username);
    }

    public User getByUsernameOfNonNull(String username) {
        return (User)this.getByUsername(username).orElseThrow(() -> new NotFoundException("The username does not exist").setErrorData((Object)username));
    }

    public Optional<User> getByEmail(String email) {
        return this.userRepository.findByEmail(email);
    }

    public User getByEmailOfNonNull(String email) {
        return (User)this.getByEmail(email).orElseThrow(() -> new NotFoundException("The email does not exist").setErrorData((Object)email));
    }

    public User updatePassword(String oldPassword, String newPassword, Integer userId) {
        Assert.hasText((String)oldPassword, (String)"Old password must not be blank");
        Assert.hasText((String)newPassword, (String)"New password must not be blank");
        Assert.notNull((Object)userId, (String)"User id must not be blank");
        if (oldPassword.equals(newPassword)) {
            throw new BadRequestException("\u65b0\u5bc6\u7801\u548c\u65e7\u5bc6\u7801\u4e0d\u80fd\u76f8\u540c");
        }
        User user = (User)this.getById((Object)userId);
        if (!BCrypt.checkpw((String)oldPassword, (String)user.getPassword())) {
            throw new BadRequestException("\u65e7\u5bc6\u7801\u9519\u8bef").setErrorData((Object)oldPassword);
        }
        this.setPassword(user, newPassword);
        User updatedUser = this.update(user);
        this.eventPublisher.publishEvent((ApplicationEvent)new LogEvent((Object)this, updatedUser.getId().toString(), LogType.PASSWORD_UPDATED, HaloUtils.desensitize((String)oldPassword, (int)2, (int)1)));
        return updatedUser;
    }

    public User createBy(UserParam userParam) {
        Assert.notNull((Object)userParam, (String)"User param must not be null");
        User user = (User)userParam.convertTo();
        this.setPassword(user, userParam.getPassword());
        return this.create(user);
    }

    public void mustNotExpire(User user) {
        Assert.notNull((Object)user, (String)"User must not be null");
        Date now = DateUtils.now();
        if (user.getExpireTime() != null && user.getExpireTime().after(now)) {
            long seconds = TimeUnit.MILLISECONDS.toSeconds(user.getExpireTime().getTime() - now.getTime());
            throw new ForbiddenException("\u8d26\u53f7\u5df2\u88ab\u505c\u7528\uff0c\u8bf7 " + HaloUtils.timeFormat((long)seconds) + " \u540e\u91cd\u8bd5").setErrorData((Object)seconds);
        }
    }

    public boolean passwordMatch(User user, String plainPassword) {
        Assert.notNull((Object)user, (String)"User must not be null");
        return !StringUtils.isBlank((CharSequence)plainPassword) && BCrypt.checkpw((String)plainPassword, (String)user.getPassword());
    }

    @CacheLock
    public User create(User user) {
        if (this.count() != 0L) {
            throw new BadRequestException("\u5f53\u524d\u535a\u5ba2\u5df2\u6709\u7528\u6237");
        }
        User createdUser = (User)super.create((Object)user);
        this.eventPublisher.publishEvent((ApplicationEvent)new UserUpdatedEvent((Object)this, createdUser.getId()));
        return createdUser;
    }

    public User update(User user) {
        User updatedUser = (User)super.update((Object)user);
        this.eventPublisher.publishEvent((ApplicationEvent)new LogEvent((Object)this, user.getId().toString(), LogType.PROFILE_UPDATED, user.getUsername()));
        this.eventPublisher.publishEvent((ApplicationEvent)new UserUpdatedEvent((Object)this, user.getId()));
        return updatedUser;
    }

    public void setPassword(@NonNull User user, @NonNull String plainPassword) {
        Assert.notNull((Object)user, (String)"User must not be null");
        Assert.hasText((String)plainPassword, (String)"Plain password must not be blank");
        user.setPassword(BCrypt.hashpw((String)plainPassword, (String)BCrypt.gensalt()));
        user.setMfaType(MFAType.NONE);
        user.setMfaKey(null);
    }

    public boolean verifyUser(String username, String password) {
        User user = (User)this.getCurrentUser().orElseThrow(() -> new ServiceException("\u672a\u67e5\u8be2\u5230\u535a\u4e3b\u4fe1\u606f"));
        return user.getUsername().equals(username) && user.getEmail().equals(password);
    }

    @NonNull
    public User updateMFA(@NonNull MFAType mfaType, String mfaKey, @NonNull Integer userId) {
        Assert.notNull((Object)mfaType, (String)"MFA Type must not be null");
        User user = (User)this.getById((Object)userId);
        user.setMfaType(mfaType);
        user.setMfaKey(MFAType.NONE == mfaType ? null : mfaKey);
        User updatedUser = this.update(user);
        this.eventPublisher.publishEvent((ApplicationEvent)new LogEvent((Object)this, updatedUser.getId().toString(), LogType.MFA_UPDATED, "MFA Type:" + mfaType));
        return updatedUser;
    }
}

