/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.task;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import run.halo.app.model.entity.BasePost;
import run.halo.app.model.enums.PostStatus;
import run.halo.app.model.enums.TimeUnit;
import run.halo.app.model.properties.PostProperties;
import run.halo.app.model.properties.PropertyEnum;
import run.halo.app.service.OptionService;
import run.halo.app.service.PostService;
import run.halo.app.task.RecycledPostCleaningTask;
import run.halo.app.utils.DateTimeUtils;

@Component
public class RecycledPostCleaningTask {
    private static final Logger log = LoggerFactory.getLogger(RecycledPostCleaningTask.class);
    private final OptionService optionService;
    private final PostService postService;

    public RecycledPostCleaningTask(OptionService optionService, PostService postService) {
        this.optionService = optionService;
        this.postService = postService;
    }

    @Scheduled(cron="0 0 */1 * * ?")
    public synchronized void run() {
        long expiredIn;
        Boolean recycledPostCleaningEnabled = (Boolean)this.optionService.getByPropertyOrDefault((PropertyEnum)PostProperties.RECYCLED_POST_CLEANING_ENABLED, Boolean.class, (Object)false);
        log.debug("{} = {}", (Object)PostProperties.RECYCLED_POST_CLEANING_ENABLED.getValue(), (Object)recycledPostCleaningEnabled);
        if (!recycledPostCleaningEnabled.booleanValue()) {
            return;
        }
        Integer recycledPostRetentionTime = (Integer)this.optionService.getByPropertyOrDefault((PropertyEnum)PostProperties.RECYCLED_POST_RETENTION_TIME, Integer.class, (Object)((Integer)PostProperties.RECYCLED_POST_RETENTION_TIME.defaultValue(Integer.class)));
        TimeUnit timeUnit = (TimeUnit)this.optionService.getEnumByPropertyOrDefault((PropertyEnum)PostProperties.RECYCLED_POST_RETENTION_TIMEUNIT, TimeUnit.class, (Enum)TimeUnit.DAY);
        log.debug("{} = {}", (Object)PostProperties.RECYCLED_POST_RETENTION_TIME.getValue(), (Object)recycledPostRetentionTime);
        log.debug("{} = {}", (Object)PostProperties.RECYCLED_POST_RETENTION_TIMEUNIT.getValue(), (Object)Objects.requireNonNull(timeUnit).name());
        switch (1.$SwitchMap$run$halo$app$model$enums$TimeUnit[timeUnit.ordinal()]) {
            case 1: {
                expiredIn = recycledPostRetentionTime.intValue();
                break;
            }
            default: {
                expiredIn = recycledPostRetentionTime * 24;
            }
        }
        List recyclePost = this.postService.listAllBy(PostStatus.RECYCLE);
        LocalDateTime now = LocalDateTime.now();
        List ids = recyclePost.stream().filter(post -> {
            LocalDateTime updateTime = DateTimeUtils.toLocalDateTime((Date)post.getUpdateTime());
            long until = updateTime.until(now, ChronoUnit.HOURS);
            return until >= expiredIn;
        }).map(BasePost::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        log.info("Start cleaning recycled posts");
        List posts = this.postService.removeByIds(ids);
        log.info("Recycled posts cleaning has been completed, {} posts has been permanently deleted", (Object)posts.size());
    }
}

