/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.theme;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.TagOpt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.app.exception.ThemePropertyMissingException;
import run.halo.app.handler.theme.config.support.ThemeProperty;
import run.halo.app.theme.ThemeFetcher;
import run.halo.app.theme.ThemeMetaLocator;
import run.halo.app.theme.ThemePropertyScanner;
import run.halo.app.utils.FileUtils;
import run.halo.app.utils.GitUtils;

public class GitThemeFetcher
implements ThemeFetcher {
    private static final Logger log = LoggerFactory.getLogger(GitThemeFetcher.class);

    public boolean support(Object source) {
        if (source instanceof String) {
            return ((String)source).endsWith(".git");
        }
        return false;
    }

    public ThemeProperty fetch(Object source) {
        String repoUrl = source.toString();
        try {
            Path tempDirectory = FileUtils.createTempDirectory();
            log.info("Cloning git repo {} to {}", (Object)repoUrl, (Object)tempDirectory);
            try (Git git = Git.cloneRepository().setTagOption(TagOpt.FETCH_TAGS).setNoCheckout(false).setDirectory(tempDirectory.toFile()).setCloneSubmodules(false).setURI(repoUrl).setRemote("upstream").call();){
                log.info("Cloned git repo {} to {} successfully", (Object)repoUrl, (Object)tempDirectory);
                Pair latestTag = GitUtils.getLatestTag((Git)git);
                CheckoutCommand checkoutCommand = git.checkout().setName("halo").setCreateBranch(true);
                if (latestTag != null) {
                    checkoutCommand.setStartPoint((RevCommit)latestTag.getValue());
                }
                Ref haloBranch = checkoutCommand.call();
                log.info("Checkout branch: {}", (Object)haloBranch.getName());
            }
            Path themePropertyPath = (Path)ThemeMetaLocator.INSTANCE.locateProperty(tempDirectory).orElseThrow(() -> new ThemePropertyMissingException("\u4e3b\u9898\u914d\u7f6e\u6587\u4ef6\u7f3a\u5931\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\uff01"));
            return (ThemeProperty)ThemePropertyScanner.INSTANCE.fetchThemeProperty(themePropertyPath.getParent()).orElseThrow();
        }
        catch (IOException | GitAPIException e) {
            throw new RuntimeException("\u4e3b\u9898\u62c9\u53d6\u5931\u8d25\uff01\uff08" + e.getMessage() + "\uff09", e);
        }
    }
}

