/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.theme;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import run.halo.app.exception.NotFoundException;
import run.halo.app.exception.ServiceException;
import run.halo.app.exception.ThemeUpdateException;
import run.halo.app.handler.theme.config.support.ThemeProperty;
import run.halo.app.repository.ThemeRepository;
import run.halo.app.theme.ThemeFetcherComposite;
import run.halo.app.theme.ThemeUpdater;
import run.halo.app.utils.GitUtils;

public class GitThemeUpdater
implements ThemeUpdater {
    private final ThemeRepository themeRepository;
    private final ThemeFetcherComposite fetcherComposite;

    public GitThemeUpdater(ThemeRepository themeRepository, ThemeFetcherComposite fetcherComposite) {
        this.themeRepository = themeRepository;
        this.fetcherComposite = fetcherComposite;
    }

    public ThemeProperty update(String themeId) throws IOException {
        ThemeProperty oldThemeProperty = (ThemeProperty)this.themeRepository.fetchThemePropertyByThemeId(themeId).orElseThrow(() -> new NotFoundException("\u4e3b\u9898 " + themeId + " \u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01").setErrorData((Object)themeId));
        String gitRepo = oldThemeProperty.getRepo();
        ThemeProperty newThemeProperty = this.fetcherComposite.fetch((Object)gitRepo);
        ThemeProperty mergedThemeProperty = this.merge(oldThemeProperty, newThemeProperty);
        Path backupPath = ThemeUpdater.backup((ThemeProperty)oldThemeProperty);
        try {
            this.themeRepository.deleteTheme(oldThemeProperty);
            return this.themeRepository.attemptToAdd(mergedThemeProperty);
        }
        catch (Throwable t) {
            log.error("Failed to add new theme, and restoring old theme from " + backupPath, t);
            ThemeUpdater.restore((Path)backupPath, (ThemeProperty)oldThemeProperty);
            log.info("Restored old theme from path: {}", (Object)backupPath);
            throw t;
        }
    }

    public ThemeProperty merge(ThemeProperty oldThemeProperty, ThemeProperty newThemeProperty) throws IOException {
        Path oldThemePath = Paths.get(oldThemeProperty.getThemePath(), new String[0]);
        try (Git oldGit = Git.init().setDirectory(oldThemePath.toFile()).call();){
            GitUtils.commitAutomatically((Git)oldGit);
            Path newThemePath = Paths.get(newThemeProperty.getThemePath(), new String[0]);
            try (Git ignored = Git.open((File)newThemePath.toFile());){
                GitUtils.removeRemoteIfExists((Git)oldGit, (String)"newTheme");
                RemoteConfig addedRemoteConfig = oldGit.remoteAdd().setName("newTheme").setUri(new URIish(newThemePath.toString())).call();
                log.info("git remote add newTheme {} {}", (Object)addedRemoteConfig.getName(), (Object)addedRemoteConfig.getURIs());
                String remote = "newTheme/halo";
                log.info("git fetch newTheme/halo");
                FetchResult fetchResult = oldGit.fetch().setRemote("newTheme").call();
                log.info("Fetch result: {}", (Object)fetchResult.getMessages());
                log.info("git rebase newTheme");
                RebaseResult rebaseResult = oldGit.rebase().setUpstream("newTheme/halo").call();
                log.info("Rebase result: {}", (Object)rebaseResult.getStatus());
                GitUtils.logCommit((RevCommit)rebaseResult.getCurrentCommit());
                if (!rebaseResult.getStatus().isSuccessful()) {
                    if (oldGit.getRepository().getRepositoryState() != RepositoryState.SAFE) {
                        RebaseResult abortRebaseResult = oldGit.rebase().setUpstream("newTheme/halo").setOperation(RebaseCommand.Operation.ABORT).call();
                        log.error("Aborted rebase with state: {} : {}", (Object)abortRebaseResult.getStatus(), (Object)abortRebaseResult.getConflicts());
                    }
                    throw new ThemeUpdateException("\u65e0\u6cd5\u81ea\u52a8\u5408\u5e76\u6700\u65b0\u6587\u4ef6\uff01\u8bf7\u5c1d\u8bd5\u5220\u9664\u4e3b\u9898\u5e76\u91cd\u65b0\u62c9\u53d6\u3002");
                }
            }
        }
        catch (URISyntaxException | GitAPIException e) {
            throw new ServiceException("\u5408\u5e76\u4e3b\u9898\u5931\u8d25\uff01\u8bf7\u786e\u8ba4\u8be5\u4e3b\u9898\u652f\u6301\u5728\u7ebf\u66f4\u65b0\u3002", e);
        }
        return newThemeProperty;
    }
}

