/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.theme;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.exception.BadRequestException;
import run.halo.app.exception.NotFoundException;
import run.halo.app.handler.theme.config.support.ThemeProperty;
import run.halo.app.repository.ThemeRepository;
import run.halo.app.theme.ThemeFetcherComposite;
import run.halo.app.theme.ThemeUpdater;

public class MultipartFileThemeUpdater
implements ThemeUpdater {
    private static final Logger log = LoggerFactory.getLogger(MultipartFileThemeUpdater.class);
    private final MultipartFile file;
    private final ThemeFetcherComposite fetcherComposite;
    private final ThemeRepository themeRepository;

    public MultipartFileThemeUpdater(MultipartFile file, ThemeFetcherComposite fetcherComposite, ThemeRepository themeRepository) {
        this.file = file;
        this.fetcherComposite = fetcherComposite;
        this.themeRepository = themeRepository;
    }

    public ThemeProperty update(String themeId) throws IOException {
        ThemeProperty oldThemeProperty = (ThemeProperty)this.themeRepository.fetchThemePropertyByThemeId(themeId).orElseThrow(() -> new NotFoundException("\u4e3b\u9898 ID \u4e3a " + themeId + " \u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff01"));
        ThemeProperty newThemeProperty = this.fetcherComposite.fetch((Object)this.file);
        if (!Objects.equals(oldThemeProperty.getId(), newThemeProperty.getId())) {
            log.error("Expected theme: {}, but provided theme: {}", (Object)oldThemeProperty.getId(), (Object)newThemeProperty.getId());
            this.themeRepository.deleteTheme(newThemeProperty);
            throw new BadRequestException("\u4e0a\u4f20\u7684\u4e3b\u9898 " + newThemeProperty.getId() + " \u548c\u5f53\u524d\u4e3b\u9898\u7684 " + oldThemeProperty.getId() + " \u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c\uff01");
        }
        Path backupPath = ThemeUpdater.backup((ThemeProperty)oldThemeProperty);
        try {
            this.themeRepository.deleteTheme(oldThemeProperty);
            return this.themeRepository.attemptToAdd(newThemeProperty);
        }
        catch (Throwable t) {
            log.error("Failed to add new theme, and restoring old theme from " + backupPath, t);
            ThemeUpdater.restore((Path)backupPath, (ThemeProperty)oldThemeProperty);
            log.info("Restored old theme from path: {}", (Object)backupPath);
            throw t;
        }
    }
}

