/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.theme;

import java.io.IOException;
import java.nio.file.Path;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import run.halo.app.exception.ServiceException;
import run.halo.app.exception.ThemePropertyMissingException;
import run.halo.app.handler.theme.config.support.ThemeProperty;
import run.halo.app.theme.ThemeFetcher;
import run.halo.app.theme.ThemePropertyScanner;
import run.halo.app.utils.FileUtils;

public class MultipartZipFileThemeFetcher
implements ThemeFetcher {
    private static final Logger log = LoggerFactory.getLogger(MultipartZipFileThemeFetcher.class);

    public boolean support(Object source) {
        if (source instanceof MultipartFile) {
            String filename = ((MultipartFile)source).getOriginalFilename();
            return filename != null && filename.endsWith(".zip");
        }
        return false;
    }

    public ThemeProperty fetch(Object source) {
        ThemeProperty themeProperty;
        MultipartFile file = (MultipartFile)source;
        ZipInputStream zis = new ZipInputStream(file.getInputStream());
        try {
            Path tempDirectory = FileUtils.createTempDirectory();
            log.info("Unzipping {} to path {}", (Object)file.getOriginalFilename(), (Object)tempDirectory);
            FileUtils.unzip((ZipInputStream)zis, (Path)tempDirectory);
            themeProperty = (ThemeProperty)ThemePropertyScanner.INSTANCE.fetchThemeProperty(tempDirectory).orElseThrow(() -> new ThemePropertyMissingException("\u4e3b\u9898\u914d\u7f6e\u6587\u4ef6\u7f3a\u5931\uff01\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    zis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ServiceException("\u4e3b\u9898\u4e0a\u4f20\u5931\u8d25\uff01", (Throwable)e);
            }
        }
        zis.close();
        return themeProperty;
    }
}

