/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.theme;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.lang.NonNull;
import run.halo.app.handler.theme.config.support.ThemeProperty;
import run.halo.app.theme.GitThemeFetcher;
import run.halo.app.theme.ThemeFetcher;

public class ThemeFetcherComposite
implements ThemeFetcher {
    private final List<ThemeFetcher> themeFetchers = new ArrayList(4);
    private final ThemeFetcher fallbackFetcher = new GitThemeFetcher();

    public ThemeFetcherComposite addFetcher(ThemeFetcher fetcher) {
        this.themeFetchers.add(fetcher);
        return this;
    }

    public ThemeFetcherComposite addFetcher(ThemeFetcher ... fetchers) {
        if (fetchers != null) {
            Collections.addAll(this.themeFetchers, fetchers);
        }
        return this;
    }

    public List<ThemeFetcher> getFetchers() {
        return Collections.unmodifiableList(this.themeFetchers);
    }

    public void clear() {
        this.themeFetchers.clear();
    }

    public boolean support(Object source) {
        return this.getThemeFetcher(source).isPresent();
    }

    public ThemeProperty fetch(Object source) {
        ThemeFetcher themeFetcher = this.getThemeFetcher(source).orElse(this.fallbackFetcher);
        return themeFetcher.fetch(source);
    }

    @NonNull
    private Optional<ThemeFetcher> getThemeFetcher(Object source) {
        return this.themeFetchers.stream().filter(fetcher -> fetcher.support(source)).findFirst();
    }
}

