/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.theme;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import run.halo.app.exception.ServiceException;
import run.halo.app.model.support.ThemeFile;
import run.halo.app.service.ThemeService;

public enum ThemeFileScanner {
    INSTANCE;


    @NonNull
    public List<ThemeFile> scan(@NonNull String absolutePath) {
        Assert.hasText((String)absolutePath, (String)"Absolute path must not be blank");
        return this.scan(Paths.get(absolutePath, new String[0]));
    }

    @NonNull
    private List<ThemeFile> scan(@NonNull Path rootPath) {
        LinkedList<ThemeFile> linkedList;
        block9: {
            Assert.notNull((Object)rootPath, (String)"Root path must not be null");
            if (!Files.isDirectory(rootPath, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> pathStream = Files.list(rootPath);
            try {
                LinkedList<ThemeFile> themeFiles = new LinkedList<ThemeFile>();
                pathStream.forEach(path -> {
                    ThemeFile themeFile = new ThemeFile();
                    themeFile.setName(path.getFileName().toString());
                    themeFile.setPath(path.toString());
                    themeFile.setIsFile(Boolean.valueOf(Files.isRegularFile(path, new LinkOption[0])));
                    themeFile.setEditable(Boolean.valueOf(this.isEditable(path)));
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        themeFile.setNode(this.scan(path));
                    }
                    themeFiles.add(themeFile);
                });
                themeFiles.sort((Comparator<ThemeFile>)new ThemeFile());
                linkedList = themeFiles;
                if (pathStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ServiceException("Failed to list sub files", (Throwable)e);
                }
            }
            pathStream.close();
        }
        return linkedList;
    }

    private boolean isEditable(@NonNull Path path) {
        boolean isEditable;
        Assert.notNull((Object)path, (String)"Path must not be null");
        boolean bl = isEditable = Files.isReadable(path) && Files.isWritable(path);
        if (!isEditable) {
            return false;
        }
        for (String suffix : ThemeService.CAN_EDIT_SUFFIX) {
            if (!path.toString().endsWith(suffix)) continue;
            return true;
        }
        return false;
    }
}

