/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.theme;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import run.halo.app.utils.FileUtils;

public enum ThemeMetaLocator {
    INSTANCE;

    private static final Logger log;
    private static final String[] THEME_PROPERTY_FILENAMES;
    private static final String[] THEME_SETTING_FILENAMES;
    private static final String THEME_SCREENSHOTS_NAME = "screenshot";

    @NonNull
    public Optional<Path> locateThemeRoot(@NonNull Path path) {
        return this.locateProperty(path).map(Path::getParent);
    }

    @NonNull
    public Optional<Path> locateProperty(@NonNull Path path) {
        try {
            Predicate<Path> predicate = ((Predicate<Path>)x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).and(Files::isReadable).and(p -> StringUtils.equalsAnyIgnoreCase((CharSequence)p.getFileName().toString(), (CharSequence[])THEME_PROPERTY_FILENAMES));
            log.debug("Locating property in path: {}", (Object)path);
            return FileUtils.findPath((Path)path, (int)3, predicate);
        }
        catch (IOException e) {
            log.warn("Error occurred while finding theme root path", (Throwable)e);
            return Optional.empty();
        }
    }

    @NonNull
    public Optional<Path> locateSetting(@NonNull Path path) {
        return this.locateThemeRoot(path).flatMap(root -> {
            try {
                Predicate<Path> predicate = ((Predicate<Path>)x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).and(Files::isReadable).and(p -> StringUtils.equalsAnyIgnoreCase((CharSequence)p.getFileName().toString(), (CharSequence[])THEME_SETTING_FILENAMES));
                log.debug("Locating setting from {}", (Object)path);
                return FileUtils.findPath((Path)path, (int)3, predicate);
            }
            catch (IOException e) {
                log.warn("Error occurred while finding theme root path", (Throwable)e);
                return Optional.empty();
            }
        });
    }

    @NonNull
    public Optional<Path> locateScreenshot(@NonNull Path path) {
        return this.locateThemeRoot(path).flatMap(root -> {
            Optional<Path> optional;
            block8: {
                Stream<Path> pathStream = Files.list(root);
                try {
                    Predicate<Path> predicate = ((Predicate<Path>)x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).and(Files::isReadable).and(p -> p.getFileName().toString().startsWith(THEME_SCREENSHOTS_NAME));
                    log.debug("Locating screenshot from path: {}", (Object)path);
                    optional = pathStream.filter(predicate).findFirst();
                    if (pathStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (pathStream != null) {
                            try {
                                pathStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.warn("Failed to list path: " + path, (Throwable)e);
                        return Optional.empty();
                    }
                }
                pathStream.close();
            }
            return optional;
        });
    }

    static {
        log = LoggerFactory.getLogger(ThemeMetaLocator.class);
        THEME_PROPERTY_FILENAMES = new String[]{"theme.yaml", "theme.yml"};
        THEME_SETTING_FILENAMES = new String[]{"settings.yaml", "settings.yml"};
    }
}

