/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.theme;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.handler.theme.config.ThemePropertyResolver;
import run.halo.app.handler.theme.config.impl.YamlThemePropertyResolver;
import run.halo.app.handler.theme.config.support.ThemeProperty;
import run.halo.app.theme.ThemeMetaLocator;

public enum ThemePropertyScanner {
    INSTANCE;

    private static final Logger log;
    private final ThemePropertyResolver propertyResolver = new YamlThemePropertyResolver();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public List<ThemeProperty> scan(@NonNull Path themePath, @Nullable String activeThemeId) {
        try {
            if (Files.notExists(themePath, new LinkOption[0])) {
                Files.createDirectories(themePath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            log.error("Failed to create directory: " + themePath, (Throwable)e);
            return Collections.emptyList();
        }
        try (Stream<Path> pathStream = Files.list(themePath);){
            List themePaths = pathStream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(themePaths)) {
                List<ThemeProperty> list2 = Collections.emptyList();
                return list2;
            }
            ThemeProperty[] properties = (ThemeProperty[])themePaths.stream().map(arg_0 -> this.fetchThemeProperty(arg_0)).filter(Optional::isPresent).map(Optional::get).peek(themeProperty -> {
                if (StringUtils.equals((CharSequence)activeThemeId, (CharSequence)themeProperty.getId())) {
                    themeProperty.setActivated(true);
                }
            }).toArray(ThemeProperty[]::new);
            List<ThemeProperty> list = Arrays.asList(properties);
            return list;
        }
        catch (IOException e) {
            log.error("Failed to get themes", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @NonNull
    public Optional<ThemeProperty> fetchThemeProperty(@NonNull Path themeRootPath) {
        Assert.notNull((Object)themeRootPath, (String)"Theme path must not be null");
        return ThemeMetaLocator.INSTANCE.locateProperty(themeRootPath).map(propertyPath -> {
            Path rootPath = propertyPath.getParent();
            try {
                String propertyContent = Files.readString(propertyPath);
                ThemeProperty themeProperty = this.propertyResolver.resolve(propertyContent);
                themeProperty.setThemePath(rootPath.toString());
                themeProperty.setFolderName(rootPath.getFileName().toString());
                themeProperty.setHasOptions(this.hasOptions(rootPath));
                themeProperty.setActivated(false);
                ThemeMetaLocator.INSTANCE.locateScreenshot(rootPath).ifPresent(screenshotPath -> {
                    String screenshotRelPath = StringUtils.join((Object[])new String[]{"/themes/", themeProperty.getFolderName(), "/", screenshotPath.getFileName().toString()});
                    themeProperty.setScreenshots(screenshotRelPath);
                });
                return themeProperty;
            }
            catch (Exception e) {
                log.warn("Failed to load theme property file", (Throwable)e);
                return null;
            }
        });
    }

    private boolean hasOptions(@NonNull Path themePath) {
        Assert.notNull((Object)themePath, (String)"Path must not be null");
        return ThemeMetaLocator.INSTANCE.locateSetting(themePath).isPresent();
    }

    static {
        log = LoggerFactory.getLogger(ThemePropertyScanner.class);
    }
}

