/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.theme;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.app.handler.theme.config.support.ThemeProperty;
import run.halo.app.utils.FileUtils;

public interface ThemeUpdater {
    public static final Logger log = LoggerFactory.getLogger(ThemeUpdater.class);

    public ThemeProperty update(String var1) throws IOException;

    public static Path backup(ThemeProperty themeProperty) throws IOException {
        Path themePath = Paths.get(themeProperty.getThemePath(), new String[0]);
        Path tempDirectory = null;
        try {
            tempDirectory = FileUtils.createTempDirectory();
            FileUtils.copyFolder((Path)themePath, (Path)tempDirectory);
            log.info("Backup theme: {} to {} successfully!", (Object)themeProperty.getId(), (Object)tempDirectory);
            return tempDirectory;
        }
        catch (IOException e) {
            FileUtils.deleteFolderQuietly((Path)tempDirectory);
            throw e;
        }
    }

    public static void restore(Path backupPath, ThemeProperty oldThemeProperty) throws IOException {
        Path targetPath = Paths.get(oldThemeProperty.getThemePath(), new String[0]);
        log.info("Restoring backup path: {} to target path: {}", (Object)backupPath, (Object)targetPath);
        FileUtils.copyFolder((Path)backupPath, (Path)targetPath);
        log.debug("Copied backup path: {} to target path: {} successfully!", (Object)backupPath, (Object)targetPath);
        FileUtils.deleteFolderQuietly((Path)backupPath);
        log.debug("Deleted backup path: {} successfully!", (Object)backupPath);
        log.info("Restored backup path: {} to target path: {} successfully!", (Object)backupPath, (Object)targetPath);
    }
}

