/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.theme;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.time.Duration;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.app.exception.ThemePropertyMissingException;
import run.halo.app.handler.theme.config.support.ThemeProperty;
import run.halo.app.theme.ThemeFetcher;
import run.halo.app.theme.ThemePropertyScanner;
import run.halo.app.utils.FileUtils;

public class ZipThemeFetcher
implements ThemeFetcher {
    private static final Logger log = LoggerFactory.getLogger(ZipThemeFetcher.class);
    private final HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).connectTimeout(Duration.ofMinutes(5L)).build();

    public boolean support(Object source) {
        if (source instanceof String) {
            return ((String)source).endsWith(".zip");
        }
        return false;
    }

    public ThemeProperty fetch(Object source) {
        ThemeProperty themeProperty;
        String themeZipLink = source.toString();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(themeZipLink)).timeout(Duration.ofMinutes(2L)).GET().build();
        log.info("Fetching theme from {}", (Object)themeZipLink);
        HttpResponse<InputStream> inputStreamResponse = this.httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
        InputStream inputStream = inputStreamResponse.body();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            Path tempDirectory = FileUtils.createTempDirectory();
            log.info("Unzipping theme {} to {}", (Object)themeZipLink, (Object)tempDirectory);
            FileUtils.unzip((ZipInputStream)zipInputStream, (Path)tempDirectory);
            themeProperty = (ThemeProperty)ThemePropertyScanner.INSTANCE.fetchThemeProperty(tempDirectory).orElseThrow(() -> new ThemePropertyMissingException("\u4e3b\u9898\u914d\u7f6e\u6587\u4ef6\u7f3a\u5931\uff01\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("\u4e3b\u9898\u62c9\u53d6\u5931\u8d25\uff01\uff08" + e.getMessage() + "\uff09", e);
            }
        }
        zipInputStream.close();
        return themeProperty;
    }
}

