/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.utils;

import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.exception.BeanUtilsException;

/*
 * Exception performing whole class analysis ignored.
 */
public class BeanUtils {
    private BeanUtils() {
    }

    @Nullable
    public static <T> T transformFrom(@Nullable Object source, @NonNull Class<T> targetClass) {
        Assert.notNull(targetClass, (String)"Target class must not be null");
        if (source == null) {
            return null;
        }
        try {
            T targetInstance = targetClass.newInstance();
            org.springframework.beans.BeanUtils.copyProperties((Object)source, targetInstance, (String[])BeanUtils.getNullPropertyNames((Object)source));
            return targetInstance;
        }
        catch (Exception e) {
            throw new BeanUtilsException("Failed to new " + targetClass.getName() + " instance or copy properties", (Throwable)e);
        }
    }

    @NonNull
    public static <T> List<T> transformFromInBatch(Collection<?> sources, @NonNull Class<T> targetClass) {
        if (CollectionUtils.isEmpty(sources)) {
            return Collections.emptyList();
        }
        return sources.stream().map(source -> BeanUtils.transformFrom((Object)source, (Class)targetClass)).collect(Collectors.toList());
    }

    public static void updateProperties(@NonNull Object source, @NonNull Object target) {
        Assert.notNull((Object)source, (String)"source object must not be null");
        Assert.notNull((Object)target, (String)"target object must not be null");
        try {
            org.springframework.beans.BeanUtils.copyProperties((Object)source, (Object)target, (String[])BeanUtils.getNullPropertyNames((Object)source));
        }
        catch (BeansException e) {
            throw new BeanUtilsException("Failed to copy properties", (Throwable)e);
        }
    }

    @NonNull
    private static String[] getNullPropertyNames(@NonNull Object source) {
        return BeanUtils.getNullPropertyNameSet((Object)source).toArray(new String[0]);
    }

    @NonNull
    private static Set<String> getNullPropertyNameSet(@NonNull Object source) {
        Assert.notNull((Object)source, (String)"source object must not be null");
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(source);
        PropertyDescriptor[] propertyDescriptors = beanWrapper.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            String propertyName = propertyDescriptor.getName();
            Object propertyValue = beanWrapper.getPropertyValue(propertyName);
            if (propertyValue != null) continue;
            emptyNames.add(propertyName);
        }
        return emptyNames;
    }
}

