/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.utils;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateTimeUtils {
    public static final String NORM_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String NORM_DATE_PATTERN = "yyyy-MM-dd";
    public static final String PURE_DATETIME_PATTERN = "yyyyMMddHHmmss";
    public static final String PURE_DATE_PATTERN = "yyyyMMdd";
    public static final DateTimeFormatter PURE_DATETIME_MS_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyyMMddHHmmss").appendValue(ChronoField.MILLI_OF_SECOND, 3).toFormatter();
    public static final DateTimeFormatter PURE_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    public static final DateTimeFormatter NORM_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final String TIME_PATTERN = "HHmm";
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HHmm");
    public static final String NORM_TIME_PATTERN = "HH:mm";
    public static final DateTimeFormatter NORM_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");
    public static final DateTimeFormatter NORM_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final String HORIZONTAL_LINE_PATTERN = "yyyy-MM-dd-HH-mm-ss-";
    public static final DateTimeFormatter HORIZONTAL_LINE_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss-");
    public static final String CTT = ZoneId.SHORT_IDS.get("CTT");
    public static final ZoneId CTT_ZONE_ID = ZoneId.of(CTT);

    private DateTimeUtils() {
    }

    public static LocalDateTime now() {
        return DateTimeUtils.now((ZoneId)CTT_ZONE_ID);
    }

    public static LocalDateTime now(ZoneId zoneId) {
        return LocalDateTime.now(zoneId);
    }

    public static String formatDate(LocalDateTime localDateTime) {
        return DateTimeUtils.format((LocalDateTime)localDateTime, (DateTimeFormatter)PURE_DATE_FORMATTER);
    }

    public static String formatDate(LocalDate localDate) {
        return DateTimeUtils.format((LocalDate)localDate, (DateTimeFormatter)PURE_DATE_FORMATTER);
    }

    public static String formatTime(LocalDateTime localDateTime) {
        return DateTimeUtils.format((LocalDateTime)localDateTime, (DateTimeFormatter)TIME_FORMATTER);
    }

    public static String formatTime(LocalTime localTime) {
        return DateTimeUtils.format((LocalTime)localTime, (DateTimeFormatter)TIME_FORMATTER);
    }

    public static String formatDateTime(LocalDateTime localDateTime) {
        return DateTimeUtils.format((LocalDateTime)localDateTime, (DateTimeFormatter)NORM_DATETIME_FORMATTER);
    }

    public static String format(LocalDateTime localDateTime, DateTimeFormatter formatter) {
        return localDateTime.format(formatter);
    }

    public static String format(LocalTime localTime, DateTimeFormatter formatter) {
        return localTime.format(formatter);
    }

    public static String format(LocalDate localDate, DateTimeFormatter formatter) {
        return localDate.format(formatter);
    }

    public static LocalDateTime parseCttDateTime(String time) {
        return DateTimeUtils.parse((String)time, (DateTimeFormatter)PURE_DATETIME_MS_FORMATTER);
    }

    public static LocalDateTime parse(String time, DateTimeFormatter formatter) {
        return LocalDateTime.parse(time, formatter);
    }

    public static Instant toInstant(LocalDateTime localDateTime) {
        return DateTimeUtils.toInstant((LocalDateTime)localDateTime, (ZoneId)CTT_ZONE_ID);
    }

    public static Instant toInstant(LocalDateTime localDateTime, ZoneId zoneId) {
        return localDateTime.atZone(zoneId).toInstant();
    }

    public static long getEpochSecond(LocalDateTime localDateTime) {
        return DateTimeUtils.toInstant((LocalDateTime)localDateTime).getEpochSecond();
    }

    public static long toEpochMilli(LocalDateTime localDateTime) {
        return DateTimeUtils.toInstant((LocalDateTime)localDateTime).toEpochMilli();
    }

    public static LocalDateTime secondAndNanoSetZero(LocalDateTime localDateTime) {
        return localDateTime.withSecond(0).withNano(0);
    }

    public static LocalDateTime plusOneDayToDateTime(LocalDateTime localDateTime) {
        return DateTimeUtils.plusDays((LocalDateTime)localDateTime, (long)1L);
    }

    public static LocalDateTime plusOneDay(LocalDateTime localDateTime, LocalTime localTime) {
        return DateTimeUtils.plusOneDay((LocalDate)localDateTime.toLocalDate(), (LocalTime)localTime);
    }

    public static LocalDateTime plusOneDay(LocalDate localDate, LocalTime localTime) {
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        return DateTimeUtils.plusDays((LocalDateTime)localDateTime, (long)1L);
    }

    public static LocalDate plusOneDayToDate(LocalDateTime localDateTime) {
        return DateTimeUtils.plusDays((LocalDateTime)localDateTime, (long)1L).toLocalDate();
    }

    public static LocalDate plusOneDayToDate(LocalDate localDate) {
        return DateTimeUtils.plusDays((LocalDate)localDate, (long)1L);
    }

    public static LocalDateTime plusDays(LocalDateTime localDateTime, long days) {
        return localDateTime.plusDays(days);
    }

    public static LocalDate plusDays(LocalDate localDate, long days) {
        return localDate.plusDays(days);
    }

    public static LocalDateTime plusOneMinute(LocalDateTime localDateTime, LocalTime localTime) {
        return DateTimeUtils.plusOneMinute((LocalDate)localDateTime.toLocalDate(), (LocalTime)localTime);
    }

    public static LocalDateTime plusOneMinute(LocalDate localDate, LocalTime localTime) {
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        return DateTimeUtils.plusMinutes((LocalDateTime)localDateTime, (long)1L);
    }

    public static LocalDateTime plusOneMinute(LocalDateTime localDateTime) {
        return DateTimeUtils.plusMinutes((LocalDateTime)localDateTime, (long)1L);
    }

    public static LocalTime plusOneMinute(LocalTime localTime) {
        return DateTimeUtils.plusMinutes((LocalTime)localTime, (long)1L);
    }

    public static LocalDateTime plusThirtyMinute(LocalDateTime localDateTime) {
        return DateTimeUtils.plusMinutes((LocalDateTime)localDateTime, (long)30L);
    }

    public static LocalTime plusThirtyMinute(LocalTime localTime) {
        return DateTimeUtils.plusMinutes((LocalTime)localTime, (long)30L);
    }

    public static LocalTime plusOneMinuteToTime(LocalDateTime localDateTime) {
        return DateTimeUtils.plusMinutes((LocalDateTime)localDateTime, (long)1L).toLocalTime();
    }

    public static LocalDateTime plusMinutes(LocalDateTime localDateTime, long minutes) {
        return localDateTime.plusMinutes(minutes);
    }

    public static LocalTime plusMinutes(LocalTime localTime, long minutes) {
        return localTime.plusMinutes(minutes);
    }

    public static LocalDateTime minusOneMinutes(LocalDateTime localDateTime, LocalTime localTime) {
        return DateTimeUtils.minusOneMinutes((LocalDate)localDateTime.toLocalDate(), (LocalTime)localTime);
    }

    public static LocalDateTime minusOneMinutes(LocalDate localDate, LocalTime localTime) {
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        return DateTimeUtils.minusMinutes((LocalDateTime)localDateTime, (long)1L);
    }

    public static LocalDateTime minusOneMinutes(LocalDateTime localDateTime) {
        return DateTimeUtils.minusMinutes((LocalDateTime)localDateTime, (long)1L);
    }

    public static LocalDateTime minusMinutes(LocalDateTime localDateTime, long minutes) {
        return localDateTime.minusMinutes(minutes);
    }

    public static LocalTime minusMinutes(LocalTime localTime, long minutes) {
        return localTime.minusMinutes(minutes);
    }

    public static boolean isNoon(LocalDateTime startInclusive) {
        LocalDateTime noonDateTime = LocalDateTime.of(startInclusive.toLocalDate(), LocalTime.NOON);
        return Duration.between(startInclusive, noonDateTime).isZero();
    }

    public static boolean isNoon(LocalTime startInclusive) {
        return Duration.between(startInclusive, LocalTime.NOON).isZero();
    }

    public static boolean isNegative(Temporal startInclusive, Temporal endInclusive) {
        return Duration.between(startInclusive, endInclusive).isNegative();
    }

    public static boolean isZero(Temporal startInclusive, Temporal endInclusive) {
        return Duration.between(startInclusive, endInclusive).isZero();
    }

    public static boolean isGreaterOrEqual(Temporal startInclusive, Temporal endInclusive) {
        return Duration.between(startInclusive, endInclusive).toNanos() >= 0L;
    }

    public static boolean isGreater(Temporal startInclusive, Temporal endInclusive) {
        return Duration.between(startInclusive, endInclusive).toNanos() > 0L;
    }

    public static boolean isLessThanOrEqual(Temporal startInclusive, Temporal endInclusive) {
        return Duration.between(startInclusive, endInclusive).toNanos() <= 0L;
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }
}

