/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import run.halo.app.exception.ForbiddenException;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static void copyFolder(@NonNull Path source, @NonNull Path target) throws IOException {
        Assert.notNull((Object)source, (String)"Source path must not be null");
        Assert.notNull((Object)target, (String)"Target path must not be null");
        Files.walkFileTree(source, (FileVisitor<? super Path>)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static void deleteFolder(@NonNull Path deletingPath) throws IOException {
        Assert.notNull((Object)deletingPath, (String)"Deleting path must not be null");
        if (Files.notExists(deletingPath, new LinkOption[0])) {
            return;
        }
        log.info("Deleting [{}]", (Object)deletingPath);
        org.eclipse.jgit.util.FileUtils.delete((File)deletingPath.toFile(), (int)3);
        log.info("Deleted [{}] successfully", (Object)deletingPath);
    }

    public static void rename(@NonNull Path pathToRename, @NonNull String newName) throws IOException {
        Assert.notNull((Object)pathToRename, (String)"File path to rename must not be null");
        Assert.notNull((Object)newName, (String)"New name must not be null");
        Path newPath = pathToRename.resolveSibling(newName);
        log.info("Rename [{}] to [{}]", (Object)pathToRename, (Object)newPath);
        Files.move(pathToRename, newPath, new CopyOption[0]);
        log.info("Rename [{}] successfully", (Object)pathToRename);
    }

    public static void unzip(@NonNull ZipInputStream zis, @NonNull Path targetPath) throws IOException {
        Assert.notNull((Object)zis, (String)"Zip input stream must not be null");
        Assert.notNull((Object)targetPath, (String)"Target path must not be null");
        FileUtils.createIfAbsent((Path)targetPath);
        FileUtils.ensureEmpty((Path)targetPath);
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            Path entryPath = targetPath.resolve(zipEntry.getName());
            FileUtils.checkDirectoryTraversal((Path)targetPath, (Path)entryPath);
            if (zipEntry.isDirectory()) {
                Files.createDirectories(entryPath, new FileAttribute[0]);
            } else {
                Files.copy(zis, entryPath, new CopyOption[0]);
            }
            zipEntry = zis.getNextEntry();
        }
    }

    public static void unzip(@NonNull byte[] bytes, @NonNull Path targetPath) throws IOException {
        Assert.notNull((Object)bytes, (String)"Zip bytes must not be null");
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(bytes));
        FileUtils.unzip((ZipInputStream)zis, (Path)targetPath);
    }

    public static void zip(@NonNull Path pathToZip, @NonNull Path pathOfArchive) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(pathOfArchive, new OpenOption[0]);
             ZipOutputStream zipOut = new ZipOutputStream(outputStream);){
            FileUtils.zip((Path)pathToZip, (ZipOutputStream)zipOut);
        }
    }

    public static void zip(@NonNull Path pathToZip, @NonNull Path pathOfArchive, @Nullable Predicate<Path> filter) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(pathOfArchive, new OpenOption[0]);
             ZipOutputStream zipOut = new ZipOutputStream(outputStream);){
            FileUtils.zip((Path)pathToZip, (ZipOutputStream)zipOut, filter);
        }
    }

    public static void zip(@NonNull Path pathToZip, @NonNull ZipOutputStream zipOut) throws IOException {
        FileUtils.zip((Path)pathToZip, (String)pathToZip.getFileName().toString(), (ZipOutputStream)zipOut);
    }

    public static void zip(@NonNull Path pathToZip, @NonNull ZipOutputStream zipOut, Predicate<Path> filter) throws IOException {
        FileUtils.zip((Path)pathToZip, (String)pathToZip.getFileName().toString(), (ZipOutputStream)zipOut, filter);
    }

    private static void zip(@NonNull Path fileToZip, @NonNull String fileName, @NonNull ZipOutputStream zipOut) throws IOException {
        FileUtils.zip((Path)fileToZip, (String)fileName, (ZipOutputStream)zipOut, null);
    }

    private static void zip(@NonNull Path fileToZip, @NonNull String fileName, @NonNull ZipOutputStream zipOut, @Nullable Predicate<Path> filter) throws IOException {
        if (Files.isDirectory(fileToZip, new LinkOption[0])) {
            log.debug("Try to zip folder: [{}]", (Object)fileToZip);
            String folderName = StringUtils.appendIfMissing((String)fileName, (CharSequence)File.separator, (CharSequence[])new CharSequence[]{File.separator});
            zipOut.putNextEntry(new ZipEntry(folderName));
            zipOut.closeEntry();
            try (Stream<Path> subPathStream = Files.list(fileToZip);){
                List subFiles = filter != null ? subPathStream.filter(filter).collect(Collectors.toList()) : subPathStream.collect(Collectors.toList());
                for (Path subFileToZip : subFiles) {
                    FileUtils.zip((Path)subFileToZip, (String)(folderName + subFileToZip.getFileName()), (ZipOutputStream)zipOut, filter);
                }
            }
        } else {
            ZipEntry zipEntry = new ZipEntry(fileName);
            zipOut.putNextEntry(zipEntry);
            Files.copy(fileToZip, zipOut);
            zipOut.closeEntry();
        }
    }

    @NonNull
    public static Optional<Path> findRootPath(@NonNull Path path, @Nullable Predicate<Path> pathPredicate) throws IOException {
        return FileUtils.findRootPath((Path)path, (int)Integer.MAX_VALUE, pathPredicate);
    }

    @NonNull
    public static Optional<Path> findRootPath(@NonNull Path path, int maxDepth, @Nullable Predicate<Path> pathPredicate) throws IOException {
        return FileUtils.findPath((Path)path, (int)maxDepth, pathPredicate).map(Path::getParent);
    }

    @NonNull
    public static Optional<Path> findPath(@NonNull Path path, @Nullable Predicate<Path> pathPredicate) throws IOException {
        return FileUtils.findPath((Path)path, (int)Integer.MAX_VALUE, pathPredicate);
    }

    @NonNull
    public static Optional<Path> findPath(@NonNull Path path, int maxDepth, @Nullable Predicate<Path> pathPredicate) throws IOException {
        Assert.isTrue((maxDepth > 0 ? 1 : 0) != 0, (String)"Max depth must not be less than 1");
        if (!Files.isDirectory(path, new LinkOption[0]) || pathPredicate == null) {
            return Optional.empty();
        }
        log.debug("Trying to find path from [{}]", (Object)path);
        LinkedList<Path> queue = new LinkedList<Path>();
        LinkedList<Integer> depthQueue = new LinkedList<Integer>();
        queue.push(path);
        depthQueue.push(1);
        boolean found = false;
        Path result = null;
        while (!found && !queue.isEmpty()) {
            Path rootPath = (Path)queue.pop();
            int depth = (Integer)depthQueue.pop();
            if (log.isDebugEnabled()) {
                log.debug("Peek({}) into {}", (Object)depth, (Object)rootPath);
            }
            Stream<Path> childrenPaths = Files.list(rootPath);
            try {
                LinkedList subFolders = new LinkedList();
                Optional<Path> resultPath = childrenPaths.peek(p -> {
                    if (Files.isDirectory(p, new LinkOption[0])) {
                        subFolders.add(p);
                    }
                }).filter(pathPredicate).findFirst();
                if (resultPath.isPresent()) {
                    queue.clear();
                    depthQueue.clear();
                    found = true;
                    result = resultPath.get();
                } else if (depth < maxDepth) {
                    for (Path subFolder : subFolders) {
                        if (Files.isHidden(subFolder)) continue;
                        queue.push(subFolder);
                        depthQueue.push(depth + 1);
                    }
                }
                subFolders.clear();
            }
            finally {
                if (childrenPaths == null) continue;
                childrenPaths.close();
            }
        }
        log.debug("Found path: [{}]", result);
        return Optional.ofNullable(result);
    }

    public static void createIfAbsent(@NonNull Path path) throws IOException {
        Assert.notNull((Object)path, (String)"Path must not be null");
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
            log.debug("Created directory: [{}]", (Object)path);
        }
    }

    public static boolean isEmpty(@NonNull Path path) throws IOException {
        Assert.notNull((Object)path, (String)"Path must not be null");
        if (!Files.isDirectory(path, new LinkOption[0]) || Files.notExists(path, new LinkOption[0])) {
            return true;
        }
        try (Stream<Path> pathStream = Files.list(path);){
            boolean bl = pathStream.count() == 0L;
            return bl;
        }
    }

    public static void ensureEmpty(@NonNull Path path) throws IOException {
        if (!FileUtils.isEmpty((Path)path)) {
            throw new DirectoryNotEmptyException("Target directory: " + path + " was not empty");
        }
    }

    public static void checkDirectoryTraversal(@NonNull String parentPath, @NonNull String pathToCheck) {
        FileUtils.checkDirectoryTraversal((Path)Paths.get(parentPath, new String[0]), (Path)Paths.get(pathToCheck, new String[0]));
    }

    public static void checkDirectoryTraversal(@NonNull Path parentPath, @NonNull String pathToCheck) {
        FileUtils.checkDirectoryTraversal((Path)parentPath, (Path)Paths.get(pathToCheck, new String[0]));
    }

    public static void checkDirectoryTraversal(@NonNull Path parentPath, @NonNull Path pathToCheck) {
        Assert.notNull((Object)parentPath, (String)"Parent path must not be null");
        Assert.notNull((Object)pathToCheck, (String)"Path to check must not be null");
        if (pathToCheck.normalize().startsWith(parentPath)) {
            return;
        }
        throw new ForbiddenException("\u4f60\u6ca1\u6709\u6743\u9650\u8bbf\u95ee " + pathToCheck).setErrorData((Object)pathToCheck);
    }

    public static void closeQuietly(@Nullable InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            log.warn("Failed to close input stream", (Throwable)e);
        }
    }

    public static void closeQuietly(@Nullable ZipInputStream zipInputStream) {
        try {
            if (zipInputStream != null) {
                zipInputStream.closeEntry();
                zipInputStream.close();
            }
        }
        catch (IOException e) {
            log.warn("Failed to close zip input stream", (Throwable)e);
        }
    }

    public static void deleteFolderQuietly(@Nullable Path deletingPath) {
        try {
            if (deletingPath != null) {
                FileUtils.deleteFolder((Path)deletingPath);
            }
        }
        catch (IOException e) {
            log.warn("Failed to delete {}", (Object)deletingPath);
        }
    }

    @NonNull
    public static Path createTempDirectory() throws IOException {
        Path tempDirectory = Files.createTempDirectory("halo", new FileAttribute[0]);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> FileUtils.deleteFolderQuietly((Path)tempDirectory)));
        return tempDirectory;
    }

    public static String readString(InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
    }

    public static void writeStringToFile(File file, String content) throws IOException {
        org.apache.commons.io.FileUtils.writeStringToFile((File)file, (String)content, (Charset)StandardCharsets.UTF_8);
    }
}

