/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.utils;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class FilenameUtils {
    private FilenameUtils() {
    }

    @NonNull
    public static String getBasename(@NonNull String filename) {
        Assert.hasText((String)filename, (String)"Filename must not be blank");
        int separatorLastIndex = StringUtils.lastIndexOf((CharSequence)filename, (int)File.separatorChar);
        if (separatorLastIndex == filename.length() - 1) {
            return "";
        }
        if (separatorLastIndex >= 0 && separatorLastIndex < filename.length() - 1) {
            filename = filename.substring(separatorLastIndex + 1);
        }
        int dotLastIndex = StringUtils.lastIndexOf((CharSequence)filename, (int)46);
        String[] split = filename.split("\\.");
        List<String> extList = Arrays.asList("gz", "bz2");
        if (extList.contains(split[split.length - 1]) && split.length >= 3) {
            return filename.substring(0, filename.substring(0, dotLastIndex).lastIndexOf(46));
        }
        if (dotLastIndex < 0) {
            return filename;
        }
        return filename.substring(0, dotLastIndex);
    }

    @NonNull
    public static String getExtension(@NonNull String filename) {
        int dotLastIndex;
        Assert.hasText((String)filename, (String)"Filename must not be blank");
        int separatorLastIndex = StringUtils.lastIndexOf((CharSequence)filename, (int)File.separatorChar);
        if (separatorLastIndex == filename.length() - 1) {
            return "";
        }
        if (separatorLastIndex >= 0 && separatorLastIndex < filename.length() - 1) {
            filename = filename.substring(separatorLastIndex + 1);
        }
        if ((dotLastIndex = StringUtils.lastIndexOf((CharSequence)filename, (int)46)) < 0) {
            return "";
        }
        String[] split = filename.split("\\.");
        List<String> extList = Arrays.asList("gz", "bz2");
        if (extList.contains(split[split.length - 1]) && split.length >= 3) {
            return filename.substring(filename.substring(0, dotLastIndex).lastIndexOf(46) + 1);
        }
        return filename.substring(dotLastIndex + 1);
    }
}

