/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class GitUtils {
    private static final Logger log = LoggerFactory.getLogger(GitUtils.class);

    private GitUtils() {
    }

    public static List<String> getAllBranchesFromRemote(@NonNull String repoUrl) {
        ArrayList<String> branches = new ArrayList<String>();
        try {
            Collection refs = Git.lsRemoteRepository().setHeads(true).setRemote(repoUrl).call();
            for (Ref ref : refs) {
                branches.add(ref.getName().substring(ref.getName().lastIndexOf("/") + 1));
            }
        }
        catch (InvalidRemoteException e) {
            log.warn("Git url is not valid: [{}]", (Object)e.getMessage());
        }
        catch (TransportException e) {
            log.warn("Transport exception: [{}]", (Object)e.getMessage());
        }
        catch (GitAPIException e) {
            log.warn("Git api exception: [{}]", (Object)e.getMessage());
        }
        return branches;
    }

    @Nullable
    public static Pair<Ref, RevCommit> getLatestTag(Git git) throws GitAPIException, IOException {
        List tags = git.tagList().call();
        if (CollectionUtils.isEmpty((Collection)tags)) {
            return null;
        }
        try (RevWalk revWalk = new RevWalk(git.getRepository());){
            revWalk.reset();
            revWalk.setTreeFilter(TreeFilter.ANY_DIFF);
            revWalk.sort(RevSort.TOPO, true);
            revWalk.sort(RevSort.COMMIT_TIME_DESC, true);
            HashMap<RevCommit, Ref> commitTagMap = new HashMap<RevCommit, Ref>(tags.size());
            for (Ref tag : tags) {
                RevCommit commit = revWalk.parseCommit((AnyObjectId)tag.getObjectId());
                commitTagMap.put(commit, tag);
                if (!log.isDebugEnabled()) continue;
                log.debug("tag: {} with commit: {} {}", new Object[]{tag.getName(), commit.getFullMessage(), new Date((long)commit.getCommitTime() * 1000L)});
            }
            Pair pair = commitTagMap.keySet().stream().max(Comparator.comparing(RevCommit::getCommitTime)).map(latestCommit -> Pair.of((Object)((Ref)commitTagMap.get(latestCommit)), (Object)latestCommit)).orElse(null);
            return pair;
        }
    }

    public static void removeRemoteIfExists(Git git, String remote) throws GitAPIException {
        boolean remoteExists = git.remoteList().call().stream().map(RemoteConfig::getName).anyMatch(name -> name.equals(remote));
        if (remoteExists) {
            RemoteConfig removedRemoteConfig = git.remoteRemove().setRemoteName(remote).call();
            log.info("git remote remove {} {}", (Object)removedRemoteConfig.getName(), (Object)removedRemoteConfig.getURIs());
        }
    }

    public static void logCommit(RevCommit commit) {
        if (commit == null) {
            return;
        }
        log.info("Commit result: {} {} {}", new Object[]{commit.getName(), commit.getFullMessage(), new Date((long)commit.getCommitTime() * 1000L)});
    }

    public static void commitAutomatically(Git git) throws GitAPIException, IOException {
        if (git.status().call().isClean()) {
            String branch = git.getRepository().getBranch();
            String fullBranch = git.getRepository().getFullBranch();
            log.info("Current branch {}", (Object)branch);
            log.info("Your branch is up to date with {}.", (Object)fullBranch);
            log.info("");
            log.info("nothing to commit, working tree clean");
            return;
        }
        git.add().addFilepattern(".").call();
        log.info("git add .");
        RevCommit commit = git.commit().setSign(Boolean.valueOf(false)).setAuthor("halo", "hi@halo.run").setMessage("Committed by halo automatically.").call();
        log.info("git commit -m \"Committed by halo automatically.\"");
        GitUtils.logCommit((RevCommit)commit);
    }
}

