/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import run.halo.app.model.support.HaloConst;

/*
 * Exception performing whole class analysis ignored.
 */
public class HaloUtils {
    private static final Logger log = LoggerFactory.getLogger(HaloUtils.class);
    public static final String URL_SEPARATOR = "/";
    private static final String RE_HTML_MARK = "(<[^<]*?>)|(<[\\s]*?/[^<]*?>)|(<[^<]*?/[\\s]*?>)";

    @NonNull
    public static String ensureBoth(@NonNull String string, @NonNull String bothfix) {
        return HaloUtils.ensureBoth((String)string, (String)bothfix, (String)bothfix);
    }

    @NonNull
    public static String ensureBoth(@NonNull String string, @NonNull String prefix, @NonNull String suffix) {
        return HaloUtils.ensureSuffix((String)HaloUtils.ensurePrefix((String)string, (String)prefix), (String)suffix);
    }

    @NonNull
    public static String ensurePrefix(@NonNull String string, @NonNull String prefix) {
        Assert.hasText((String)string, (String)"String must not be blank");
        Assert.hasText((String)prefix, (String)"Prefix must not be blank");
        return prefix + StringUtils.removeStart((String)string, (String)prefix);
    }

    @NonNull
    public static String ensureSuffix(@NonNull String string, @NonNull String suffix) {
        Assert.hasText((String)string, (String)"String must not be blank");
        Assert.hasText((String)suffix, (String)"Suffix must not be blank");
        return StringUtils.removeEnd((String)string, (String)suffix) + suffix;
    }

    public static String compositeHttpUrl(String ... partUrls) {
        Assert.notEmpty((Object[])partUrls, (String)"Partial url must not be blank");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < partUrls.length; ++i) {
            String partUrl = partUrls[i];
            if (StringUtils.isBlank((CharSequence)partUrl)) continue;
            partUrl = StringUtils.removeStart((String)partUrl, (String)"/");
            partUrl = StringUtils.removeEnd((String)partUrl, (String)"/");
            if (i != 0) {
                builder.append("/");
            }
            builder.append(partUrl);
        }
        return builder.toString();
    }

    public static String desensitize(@NonNull String plainText, int leftSize, int rightSize) {
        Assert.hasText((String)plainText, (String)"Plain text must not be blank");
        if (leftSize < 0) {
            leftSize = 0;
        }
        if (leftSize > plainText.length()) {
            leftSize = plainText.length();
        }
        if (rightSize < 0) {
            rightSize = 0;
        }
        if (rightSize > plainText.length()) {
            rightSize = plainText.length();
        }
        if (plainText.length() < leftSize + rightSize) {
            rightSize = plainText.length() - leftSize;
        }
        int remainSize = plainText.length() - rightSize - leftSize;
        String left = StringUtils.left((String)plainText, (int)leftSize);
        String right = StringUtils.right((String)plainText, (int)rightSize);
        return StringUtils.rightPad((String)left, (int)(remainSize + leftSize), (char)'*') + right;
    }

    public static String changeFileSeparatorToUrlSeparator(@NonNull String pathname) {
        Assert.hasText((String)pathname, (String)"Path name must not be blank");
        return pathname.replace(HaloConst.FILE_SEPARATOR, "/");
    }

    @NonNull
    public static String timeFormat(long totalSeconds) {
        if (totalSeconds <= 0L) {
            return "0 second";
        }
        StringBuilder timeBuilder = new StringBuilder();
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 3600L % 60L;
        if (hours > 0L) {
            if (StringUtils.isNotBlank((CharSequence)timeBuilder)) {
                timeBuilder.append(", ");
            }
            timeBuilder.append(HaloUtils.pluralize((long)hours, (String)"hour", (String)"hours"));
        }
        if (minutes > 0L) {
            if (StringUtils.isNotBlank((CharSequence)timeBuilder)) {
                timeBuilder.append(", ");
            }
            timeBuilder.append(HaloUtils.pluralize((long)minutes, (String)"minute", (String)"minutes"));
        }
        if (seconds > 0L) {
            if (StringUtils.isNotBlank((CharSequence)timeBuilder)) {
                timeBuilder.append(", ");
            }
            timeBuilder.append(HaloUtils.pluralize((long)seconds, (String)"second", (String)"seconds"));
        }
        return timeBuilder.toString();
    }

    @NonNull
    public static String pluralize(long times, @NonNull String label, @NonNull String pluralLabel) {
        Assert.hasText((String)label, (String)"Label must not be blank");
        Assert.hasText((String)pluralLabel, (String)"Plural label must not be blank");
        if (times <= 0L) {
            return "no " + pluralLabel;
        }
        if (times == 1L) {
            return times + " " + label;
        }
        return times + " " + pluralLabel;
    }

    @NonNull
    public static String randomUUIDWithoutDash() {
        return StringUtils.remove((String)UUID.randomUUID().toString(), (char)'-');
    }

    @NonNull
    public static String initializeUrlIfBlank(@Nullable String url) {
        if (!StringUtils.isBlank((CharSequence)url)) {
            return url;
        }
        return String.valueOf(System.currentTimeMillis());
    }

    @NonNull
    public static String normalizeUrl(@NonNull String originalUrl) {
        String body;
        String protocol;
        Assert.hasText((String)originalUrl, (String)"Original Url must not be blank");
        if (StringUtils.startsWithAny((CharSequence)originalUrl, (CharSequence[])new CharSequence[]{"/", "https://", "http://"}) && !StringUtils.startsWith((CharSequence)originalUrl, (CharSequence)"//")) {
            return originalUrl;
        }
        int sepIndex = originalUrl.indexOf("://");
        if (sepIndex > 0) {
            protocol = StringUtils.substring((String)originalUrl, (int)0, (int)(sepIndex + 3));
            body = StringUtils.substring((String)originalUrl, (int)(sepIndex + 3), (int)originalUrl.length());
        } else {
            protocol = "http://";
            body = originalUrl;
        }
        int paramsSepIndex = StringUtils.indexOf((CharSequence)body, (int)63);
        String params = null;
        if (paramsSepIndex > 0) {
            params = StringUtils.substring((String)body, (int)paramsSepIndex, (int)body.length());
            body = StringUtils.substring((String)body, (int)0, (int)paramsSepIndex);
        }
        if (StringUtils.isNotEmpty((CharSequence)body)) {
            body = body.replaceAll("^[\\\\/]+", "");
            body = body.replace("\\", "/").replaceAll("//+", "/");
        }
        int pathSepIndex = StringUtils.indexOf((CharSequence)body, (int)47);
        String domain = body;
        String path = null;
        if (pathSepIndex > 0) {
            domain = StringUtils.substring((String)body, (int)0, (int)pathSepIndex);
            path = StringUtils.substring((String)body, (int)pathSepIndex, (int)body.length());
        }
        return protocol + domain + (String)StringUtils.defaultIfEmpty(path, (CharSequence)"") + (String)StringUtils.defaultIfEmpty((CharSequence)params, (CharSequence)"");
    }

    public static String getMachineIP() {
        InetAddress machineAddress;
        try {
            machineAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            machineAddress = InetAddress.getLoopbackAddress();
        }
        return machineAddress.getHostAddress();
    }

    public static String cleanHtmlTag(String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return "";
        }
        return content.replaceAll("(<[^<]*?>)|(<[\\s]*?/[^<]*?>)|(<[^<]*?/[\\s]*?>)", "");
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static String strip(String str, String prefixStripChars, String suffixStripChars) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        str = StringUtils.stripStart((String)str, (String)prefixStripChars);
        return StringUtils.stripEnd((String)str, (String)suffixStripChars);
    }

    public static int[] rainbow(int pageNo, int totalPage, int displayCount) {
        boolean isEven = displayCount % 2 == 0;
        int left = displayCount / 2;
        int right = displayCount / 2;
        int length = displayCount;
        if (isEven) {
            ++right;
        }
        if (totalPage < displayCount) {
            length = totalPage;
        }
        int[] result = new int[length];
        if (totalPage >= displayCount) {
            if (pageNo <= left) {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = i + 1;
                }
            } else if (pageNo > totalPage - right) {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = i + totalPage - displayCount + 1;
                }
            } else {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = i + pageNo - left + (isEven ? 1 : 0);
                }
            }
        } else {
            for (int i = 0; i < result.length; ++i) {
                result[i] = i + 1;
            }
        }
        return result;
    }

    public static String simpleUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static byte[] generateQrCodeToPng(String content, int width, int height) {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>(3, 1.0f);
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
        hints.put(EncodeHintType.MARGIN, 2);
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        try {
            BitMatrix byteMatrix = qrCodeWriter.encode(content, BarcodeFormat.QR_CODE, width, height, hints);
            int matrixWidth = byteMatrix.getWidth();
            int matrixHeight = byteMatrix.getHeight();
            BufferedImage image = new BufferedImage(matrixWidth, matrixHeight, 1);
            image.createGraphics();
            Graphics2D graphics = (Graphics2D)image.getGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, matrixWidth, matrixHeight);
            graphics.setColor(Color.BLACK);
            for (int i = 0; i < matrixWidth; ++i) {
                for (int j = 0; j < matrixWidth; ++j) {
                    if (!byteMatrix.get(i, j)) continue;
                    graphics.fillRect(i, j, 1, 1);
                }
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", os);
            return os.toByteArray();
        }
        catch (WriterException | IOException e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

