/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.utils;

import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.springframework.lang.NonNull;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpClientUtils {
    private static final int TIMEOUT = 5000;

    private HttpClientUtils() {
    }

    @NonNull
    public static CloseableHttpClient createHttpsClient(int timeout) throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (certificate, authType) -> true).build();
        return HttpClientUtils.resolveProxySetting((HttpClientBuilder)HttpClients.custom()).setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setDefaultRequestConfig(HttpClientUtils.getRequestConfig((int)timeout)).build();
    }

    private static HttpClientBuilder resolveProxySetting(HttpClientBuilder httpClientBuilder) {
        String httpProxyEnv = System.getenv("http_proxy");
        if (StringUtils.isNotBlank((CharSequence)httpProxyEnv)) {
            String[] httpProxy = HttpClientUtils.resolveHttpProxy((String)httpProxyEnv);
            HttpHost httpHost = HttpHost.create((String)httpProxy[0]);
            httpClientBuilder.setProxy(httpHost);
            if (httpProxy.length == 3) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(httpHost.getHostName(), httpHost.getPort()), (Credentials)new UsernamePasswordCredentials(httpProxy[1], httpProxy[2]));
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
        }
        return httpClientBuilder;
    }

    private static String[] resolveHttpProxy(String httpProxy) {
        URI proxyUri = URI.create(httpProxy);
        int port = proxyUri.getPort();
        if (port == -1) {
            if (Objects.equals("http", proxyUri.getScheme())) {
                port = 80;
            }
            if (Objects.equals("https", proxyUri.getScheme())) {
                port = 443;
            }
        }
        String hostUrl = proxyUri.getScheme() + "://" + proxyUri.getHost() + ":" + port;
        String usernamePassword = proxyUri.getUserInfo();
        if (StringUtils.isNotBlank((CharSequence)usernamePassword)) {
            String password;
            String username;
            int atColon = usernamePassword.indexOf(58);
            if (atColon >= 0) {
                username = usernamePassword.substring(0, atColon);
                password = usernamePassword.substring(atColon + 1);
            } else {
                username = usernamePassword;
                password = null;
            }
            return new String[]{hostUrl, username, password};
        }
        return new String[]{hostUrl};
    }

    private static RequestConfig getRequestConfig(int timeout) {
        return RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
    }
}

