/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.utils;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.sf.image4j.codec.ico.ICODecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import run.halo.app.exception.ImageFormatException;

public class ImageUtils {
    private static final Logger log = LoggerFactory.getLogger(ImageUtils.class);
    public static final String EXTENSION_ICO = "ico";

    public static BufferedImage getImageFromFile(InputStream is, String extension) throws IOException {
        log.debug("Current File type is : [{}]", (Object)extension);
        if (EXTENSION_ICO.equals(extension)) {
            try {
                return (BufferedImage)ICODecoder.read((InputStream)is).get(0);
            }
            catch (IOException e) {
                throw new ImageFormatException("ico \u6587\u4ef6\u5df2\u635f\u574f", (Throwable)e);
            }
        }
        return ImageIO.read(is);
    }

    @NonNull
    public static ImageReader getImageReaderFromFile(InputStream is, String formatName) throws IOException {
        try {
            Iterator<ImageReader> readerIterator = ImageIO.getImageReadersByFormatName(formatName);
            ImageReader reader = readerIterator.next();
            ImageInputStream stream = ImageIO.createImageInputStream(is);
            ImageIO.getImageReadersByFormatName(formatName);
            reader.setInput(stream, true);
            return reader;
        }
        catch (Exception e) {
            throw new IOException("Failed to read image reader.", e);
        }
    }
}

