/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.IOException;
import java.util.Map;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public class JsonUtils {
    public static final ObjectMapper DEFAULT_JSON_MAPPER = JsonUtils.createDefaultJsonMapper();

    private JsonUtils() {
    }

    public static ObjectMapper createDefaultJsonMapper() {
        return JsonUtils.createDefaultJsonMapper(null);
    }

    @NonNull
    public static ObjectMapper createDefaultJsonMapper(@Nullable PropertyNamingStrategy strategy) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        if (strategy != null) {
            mapper.setPropertyNamingStrategy(strategy);
        }
        return mapper;
    }

    @NonNull
    public static <T> T jsonToObject(@NonNull String json, @NonNull Class<T> type) throws IOException {
        return (T)JsonUtils.jsonToObject((String)json, type, (ObjectMapper)DEFAULT_JSON_MAPPER);
    }

    public static <T> T jsonToObject(String json, TypeReference<T> typeReference) {
        try {
            return (T)DEFAULT_JSON_MAPPER.readValue(json, typeReference);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @NonNull
    public static <T> T jsonToObject(@NonNull String json, @NonNull Class<T> type, @NonNull ObjectMapper objectMapper) throws IOException {
        Assert.hasText((String)json, (String)"Json content must not be blank");
        Assert.notNull(type, (String)"Target type must not be null");
        Assert.notNull((Object)objectMapper, (String)"Object mapper must not null");
        return (T)objectMapper.readValue(json, type);
    }

    @NonNull
    public static String objectToJson(@NonNull Object source) throws JsonProcessingException {
        return JsonUtils.objectToJson((Object)source, (ObjectMapper)DEFAULT_JSON_MAPPER);
    }

    @NonNull
    public static String objectToJson(@NonNull Object source, @NonNull ObjectMapper objectMapper) throws JsonProcessingException {
        Assert.notNull((Object)source, (String)"Source object must not be null");
        Assert.notNull((Object)objectMapper, (String)"Object mapper must not null");
        return objectMapper.writeValueAsString(source);
    }

    @NonNull
    public static <T> T mapToObject(@NonNull Map<String, ?> sourceMap, @NonNull Class<T> type) throws IOException {
        return (T)JsonUtils.mapToObject(sourceMap, type, (ObjectMapper)DEFAULT_JSON_MAPPER);
    }

    @NonNull
    public static <T> T mapToObject(@NonNull Map<String, ?> sourceMap, @NonNull Class<T> type, @NonNull ObjectMapper objectMapper) throws IOException {
        Assert.notEmpty(sourceMap, (String)"Source map must not be empty");
        String json = JsonUtils.objectToJson(sourceMap, (ObjectMapper)objectMapper);
        return (T)JsonUtils.jsonToObject((String)json, type, (ObjectMapper)objectMapper);
    }

    @NonNull
    public static Map<?, ?> objectToMap(@NonNull Object source) throws IOException {
        return JsonUtils.objectToMap((Object)source, (ObjectMapper)DEFAULT_JSON_MAPPER);
    }

    @NonNull
    public static Map<?, ?> objectToMap(@NonNull Object source, @NonNull ObjectMapper objectMapper) throws IOException {
        String json = JsonUtils.objectToJson((Object)source, (ObjectMapper)objectMapper);
        return (Map)JsonUtils.jsonToObject((String)json, Map.class, (ObjectMapper)objectMapper);
    }
}

