/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ServiceUtils {
    private ServiceUtils() {
    }

    @NonNull
    public static <I, T> Set<I> fetchProperty(Collection<T> datas, Function<T, I> mappingFunction) {
        return CollectionUtils.isEmpty(datas) ? Collections.emptySet() : datas.stream().map(mappingFunction).collect(Collectors.toSet());
    }

    @NonNull
    public static <I, D> Map<I, List<D>> convertToListMap(Collection<I> ids, Collection<D> list, Function<D, I> mappingFunction) {
        Assert.notNull(mappingFunction, (String)"mapping function must not be null");
        if (CollectionUtils.isEmpty(ids) || CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        HashMap resultMap = new HashMap();
        list.forEach(data -> resultMap.computeIfAbsent(mappingFunction.apply(data), id -> new LinkedList()).add(data));
        ids.forEach(id -> resultMap.putIfAbsent(id, Collections.emptyList()));
        return resultMap;
    }

    @NonNull
    public static <I, D> Map<I, D> convertToMap(Collection<D> list, Function<D, I> mappingFunction) {
        Assert.notNull(mappingFunction, (String)"mapping function must not be null");
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        HashMap resultMap = new HashMap();
        list.forEach(data -> resultMap.putIfAbsent(mappingFunction.apply(data), data));
        return resultMap;
    }

    @NonNull
    public static <I, D, V> Map<I, V> convertToMap(@Nullable Collection<D> list, @NonNull Function<D, I> keyFunction, @NonNull Function<D, V> valueFunction) {
        Assert.notNull(keyFunction, (String)"Key function must not be null");
        Assert.notNull(valueFunction, (String)"Value function must not be null");
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        HashMap resultMap = new HashMap();
        list.forEach(data -> resultMap.putIfAbsent(keyFunction.apply(data), valueFunction.apply(data)));
        return resultMap;
    }

    public static boolean isEmptyId(@Nullable Number id) {
        return id == null || id.longValue() <= 0L;
    }

    @NonNull
    public static Pageable buildLatestPageable(int top) {
        return ServiceUtils.buildLatestPageable((int)top, (String)"createTime");
    }

    @NonNull
    public static Pageable buildLatestPageable(int top, @NonNull String sortProperty) {
        Assert.isTrue((top > 0 ? 1 : 0) != 0, (String)"Top number must not be less than 0");
        Assert.hasText((String)sortProperty, (String)"Sort property must not be blank");
        return PageRequest.of((int)0, (int)top, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{sortProperty}));
    }

    @NonNull
    public static <T, S> Page<T> buildEmptyPageImpl(@NonNull Page<S> page) {
        Assert.notNull(page, (String)"Page result must not be null");
        return new PageImpl(Collections.emptyList(), page.getPageable(), page.getTotalElements());
    }
}

