/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.utils;

import java.util.Enumeration;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
public class ServletUtils {
    private ServletUtils() {
    }

    @NonNull
    public static Optional<HttpServletRequest> getCurrentRequest() {
        return Optional.ofNullable(RequestContextHolder.getRequestAttributes()).filter(requestAttributes -> requestAttributes instanceof ServletRequestAttributes).map(requestAttributes -> (ServletRequestAttributes)requestAttributes).map(ServletRequestAttributes::getRequest);
    }

    @Nullable
    public static String getRequestIp() {
        return ServletUtils.getCurrentRequest().map(x$0 -> ServletUtils.getClientIP((HttpServletRequest)x$0, (String[])new String[0])).orElse(null);
    }

    @Nullable
    public static String getHeaderIgnoreCase(String header) {
        return ServletUtils.getCurrentRequest().map(request -> ServletUtils.getHeaderIgnoreCase((HttpServletRequest)request, (String)header)).orElse(null);
    }

    public static String getHeaderIgnoreCase(HttpServletRequest request, String nameIgnoreCase) {
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (name == null || !name.equalsIgnoreCase(nameIgnoreCase)) continue;
            return request.getHeader(name);
        }
        return null;
    }

    public static String getClientIP(HttpServletRequest request, String ... otherHeaderNames) {
        Object[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (ArrayUtils.isNotEmpty((Object[])otherHeaderNames)) {
            headers = (String[])ArrayUtils.addAll((Object[])headers, (Object[])otherHeaderNames);
        }
        return ServletUtils.getClientIPByHeader((HttpServletRequest)request, (String[])headers);
    }

    public static boolean isUnknown(String checkString) {
        return StringUtils.isBlank((CharSequence)checkString) || "unknown".equalsIgnoreCase(checkString);
    }

    public static String getClientIPByHeader(HttpServletRequest request, String ... headerNames) {
        String ip;
        for (String header : headerNames) {
            ip = request.getHeader(header);
            if (ServletUtils.isUnknown((String)ip)) continue;
            return ServletUtils.getMultistageReverseProxyIp((String)ip);
        }
        ip = request.getRemoteAddr();
        return ServletUtils.getMultistageReverseProxyIp((String)ip);
    }

    public static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(",")) {
                if (ServletUtils.isUnknown((String)subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }
}

