/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.utils;

import java.text.Normalizer;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class SlugUtils {
    private static final Pattern NON_LATIN = Pattern.compile("[^\\w-]");
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]");

    @NonNull
    @Deprecated
    public static String slugify(@NonNull String input) {
        Assert.hasText((String)input, (String)"Input string must not be blank");
        String withoutWhitespace = WHITESPACE.matcher(input).replaceAll("-");
        String normalized = Normalizer.normalize(withoutWhitespace, Normalizer.Form.NFKD);
        String slug = NON_LATIN.matcher(normalized).replaceAll("");
        return slug.toLowerCase(Locale.ENGLISH);
    }

    public static String slug(@NonNull String input) {
        Assert.hasText((String)input, (String)"Input string must not be blank");
        String slug = input.replaceAll("[^(a-zA-Z0-9\\u4e00-\\u9fa5\\.\\-)]", "").replaceAll("[\\?\\\\/:|<>\\*\\[\\]\\(\\)\\$%\\{\\}@~\\.]", "").replaceAll("\\s", "").toLowerCase(Locale.ENGLISH);
        return StringUtils.isNotEmpty((CharSequence)slug) ? slug : String.valueOf(System.currentTimeMillis());
    }
}

