/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.utils;

import java.security.GeneralSecurityException;
import run.halo.app.exception.AuthenticationException;
import run.halo.app.exception.BadRequestException;
import run.halo.app.utils.TwoFactorAuthUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class TwoFactorAuthUtils {
    private static final int VALID_TFA_WINDOW_MILLIS = 60000;

    public static String generateTFAKey() {
        return TimeBasedOneTimePasswordUtil.generateBase32Secret((int)32);
    }

    public static String generateTFACode(String tfaKey) {
        try {
            return TimeBasedOneTimePasswordUtil.generateCurrentNumberString((String)tfaKey);
        }
        catch (GeneralSecurityException e) {
            throw new AuthenticationException("\u4e24\u6b65\u9a8c\u8bc1\u7801\u751f\u6210\u5f02\u5e38");
        }
    }

    public static void validateTFACode(String tfaKey, String tfaCode) {
        try {
            int validCode = Integer.parseInt(tfaCode);
            boolean result = TimeBasedOneTimePasswordUtil.validateCurrentNumber((String)tfaKey, (int)validCode, (int)60000);
            if (!result) {
                throw new BadRequestException("\u4e24\u6b65\u9a8c\u8bc1\u7801\u9a8c\u8bc1\u9519\u8bef\uff0c\u8bf7\u786e\u8ba4\u65f6\u95f4\u662f\u5426\u540c\u6b65");
            }
        }
        catch (NumberFormatException e) {
            throw new BadRequestException("\u4e24\u6b65\u9a8c\u8bc1\u7801\u8bf7\u8f93\u5165\u6570\u5b57");
        }
        catch (GeneralSecurityException e) {
            throw new BadRequestException("\u4e24\u6b65\u9a8c\u8bc1\u7801\u9a8c\u8bc1\u5f02\u5e38");
        }
    }

    public static String generateOtpAuthUrl(String userName, String tfaKey) {
        return TimeBasedOneTimePasswordUtil.generateOtpAuthUrl((String)userName, (String)tfaKey);
    }
}

