/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.FieldError;

/*
 * Exception performing whole class analysis ignored.
 */
public class ValidationUtils {
    public static final Pattern EMAIL = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)])", 2);
    private static volatile Validator VALIDATOR;

    private ValidationUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static Validator getValidator() {
        if (VALIDATOR != null) return VALIDATOR;
        Class<ValidationUtils> clazz = ValidationUtils.class;
        synchronized (ValidationUtils.class) {
            if (VALIDATOR != null) return VALIDATOR;
            VALIDATOR = Validation.buildDefaultValidatorFactory().getValidator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return VALIDATOR;
        }
    }

    public static void validate(Object obj, Class<?> ... groups) {
        Validator validator = ValidationUtils.getValidator();
        if (obj instanceof Iterable) {
            ValidationUtils.validate((Iterable)((Iterable)obj), (Class[])groups);
        } else {
            Set constraintViolations = validator.validate(obj, (Class[])groups);
            if (!CollectionUtils.isEmpty((Collection)constraintViolations)) {
                throw new ConstraintViolationException(constraintViolations);
            }
        }
    }

    public static void validate(@Nullable Iterable<?> objs, Class<?> ... groups) {
        if (objs == null) {
            return;
        }
        Validator validator = ValidationUtils.getValidator();
        AtomicInteger i = new AtomicInteger(0);
        LinkedHashSet allViolations = new LinkedHashSet();
        objs.forEach(obj -> {
            int index = i.getAndIncrement();
            Set violations = validator.validate(obj, groups);
            violations.forEach(violation -> {
                Path path = violation.getPropertyPath();
                if (path instanceof PathImpl) {
                    PathImpl pathImpl = (PathImpl)path;
                    pathImpl.makeLeafNodeIterableAndSetIndex(Integer.valueOf(index));
                }
                allViolations.add(violation);
            });
        });
        if (!CollectionUtils.isEmpty(allViolations)) {
            throw new ConstraintViolationException(allViolations);
        }
    }

    @NonNull
    public static Map<String, String> mapWithValidError(Set<ConstraintViolation<?>> constraintViolations) {
        if (CollectionUtils.isEmpty(constraintViolations)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> errMap = new HashMap<String, String>(4);
        constraintViolations.forEach(constraintViolation -> errMap.put(constraintViolation.getPropertyPath().toString(), constraintViolation.getMessage()));
        return errMap;
    }

    public static Map<String, String> mapWithFieldError(@Nullable List<FieldError> fieldErrors) {
        if (CollectionUtils.isEmpty(fieldErrors)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> errMap = new HashMap<String, String>(4);
        fieldErrors.forEach(filedError -> errMap.put(filedError.getField(), filedError.getDefaultMessage()));
        return errMap;
    }

    public static boolean isEmail(String email) {
        return EMAIL.matcher(email).matches();
    }
}

