/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.utils;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import run.halo.app.utils.Version;

/*
 * Exception performing whole class analysis ignored.
 */
public class Version {
    private static final Logger log = LoggerFactory.getLogger(Version.class);
    private static final String REGEX = "^(?<major>0|[1-9]\\d*)\\.(?<minor>0|[1-9]\\d*)\\.(?<patch>0|[1-9]\\d*)(?:-(?<preRelease>beta|alpha|rc)\\.(?<preReleaseMajor>0|[1-9]\\d*))?$";
    private static final Pattern PATTERN = Pattern.compile("^(?<major>0|[1-9]\\d*)\\.(?<minor>0|[1-9]\\d*)\\.(?<patch>0|[1-9]\\d*)(?:-(?<preRelease>beta|alpha|rc)\\.(?<preReleaseMajor>0|[1-9]\\d*))?$");
    private static final Version EMPTY_VERSION = new Version(0L, 0L, 0L);
    private static final Version MAXIMUM_VERSION = new Version(Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE);
    private final long major;
    private final long minor;
    private final long patch;
    private final PreRelease preRelease;
    private final long preReleaseMajor;

    public Version() {
        this(0L, 0L, 0L);
    }

    public Version(long major, long minor, long patch) {
        this(major, minor, patch, null, null);
    }

    public Version(long major, long minor, long patch, @Nullable PreRelease preRelease, @Nullable Long preReleaseMajor) {
        if (major < 0L) {
            major = 0L;
        }
        if (minor < 0L) {
            minor = 0L;
        }
        if (patch < 0L) {
            minor = 0L;
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease;
        if (preRelease != null) {
            if ((preReleaseMajor = Long.valueOf(preReleaseMajor == null ? Integer.MAX_VALUE : preReleaseMajor)) < 0L) {
                preReleaseMajor = 0L;
            }
            this.preReleaseMajor = preReleaseMajor;
        } else {
            this.preReleaseMajor = Integer.MAX_VALUE;
        }
    }

    @NonNull
    public static Version emptyVersion() {
        return EMPTY_VERSION;
    }

    @NonNull
    public static Optional<Version> resolve(@Nullable String version) {
        if (StringUtils.isBlank((CharSequence)version)) {
            return Optional.empty();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)version, (CharSequence)"unknown")) {
            return Optional.of(MAXIMUM_VERSION);
        }
        Matcher matcher = PATTERN.matcher(version);
        if (!matcher.matches()) {
            log.warn("Version: [{}] didn't match version format", (Object)version);
            return Optional.empty();
        }
        String major = matcher.group("major");
        String minor = matcher.group("minor");
        String patch = matcher.group("patch");
        String preRelease = matcher.group("preRelease");
        String preReleaseMajor = matcher.group("preReleaseMajor");
        return Optional.of(new Version(Long.parseLong(major), Long.parseLong(minor), Long.parseLong(patch), PreRelease.of((String)preRelease), StringUtils.isNotBlank((CharSequence)preReleaseMajor) ? Long.valueOf(Long.parseLong(preReleaseMajor)) : null));
    }

    public boolean compatible(String target) {
        Version targetVersion = Version.resolve((String)target).orElse(Version.emptyVersion());
        int majorCompare = Long.compare(this.major, targetVersion.major);
        if (majorCompare != 0) {
            return majorCompare > 0;
        }
        int minorCompare = Long.compare(this.minor, targetVersion.minor);
        if (minorCompare != 0) {
            return minorCompare > 0;
        }
        int patchCompare = Long.compare(this.patch, targetVersion.patch);
        if (patchCompare != 0) {
            return patchCompare > 0;
        }
        if (!this.isPreRelease() || !targetVersion.isPreRelease()) {
            return true;
        }
        int preReleaseTagCompare = PreRelease.ALPHA.compare(Objects.requireNonNull(this.preRelease), Objects.requireNonNull(targetVersion.preRelease));
        if (preReleaseTagCompare != 0) {
            return preReleaseTagCompare > 0;
        }
        long preReleaseNumberCompare = this.preReleaseMajor - targetVersion.preReleaseMajor;
        if (preReleaseNumberCompare != 0L) {
            return preReleaseNumberCompare > 0L;
        }
        return true;
    }

    public boolean isPreRelease() {
        return this.preRelease != null;
    }

    public long getMajor() {
        return this.major;
    }

    public long getMinor() {
        return this.minor;
    }

    public long getPatch() {
        return this.patch;
    }

    public PreRelease getPreRelease() {
        return this.preRelease;
    }

    public long getPreReleaseMajor() {
        return this.preReleaseMajor;
    }

    public String toString() {
        return "Version(major=" + this.getMajor() + ", minor=" + this.getMinor() + ", patch=" + this.getPatch() + ", preRelease=" + this.getPreRelease() + ", preReleaseMajor=" + this.getPreReleaseMajor() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getMajor() != other.getMajor()) {
            return false;
        }
        if (this.getMinor() != other.getMinor()) {
            return false;
        }
        if (this.getPatch() != other.getPatch()) {
            return false;
        }
        if (this.getPreReleaseMajor() != other.getPreReleaseMajor()) {
            return false;
        }
        PreRelease this$preRelease = this.getPreRelease();
        PreRelease other$preRelease = other.getPreRelease();
        return !(this$preRelease == null ? other$preRelease != null : !this$preRelease.equals(other$preRelease));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Version;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $major = this.getMajor();
        result = result * 59 + (int)($major >>> 32 ^ $major);
        long $minor = this.getMinor();
        result = result * 59 + (int)($minor >>> 32 ^ $minor);
        long $patch = this.getPatch();
        result = result * 59 + (int)($patch >>> 32 ^ $patch);
        long $preReleaseMajor = this.getPreReleaseMajor();
        result = result * 59 + (int)($preReleaseMajor >>> 32 ^ $preReleaseMajor);
        PreRelease $preRelease = this.getPreRelease();
        result = result * 59 + ($preRelease == null ? 43 : $preRelease.hashCode());
        return result;
    }
}

