/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.utils.footnotes.internal;

import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.BlockContent;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.regex.Pattern;
import run.halo.app.utils.footnotes.FootnoteBlock;
import run.halo.app.utils.footnotes.FootnoteExtension;
import run.halo.app.utils.footnotes.internal.FootnoteOptions;
import run.halo.app.utils.footnotes.internal.FootnoteRepository;

public class FootnoteBlockParser
extends AbstractBlockParser {
    static String FOOTNOTE_ID = ".*";
    static Pattern FOOTNOTE_ID_PATTERN = Pattern.compile("\\[\\^\\s*(" + FOOTNOTE_ID + ")\\s*\\]");
    static Pattern FOOTNOTE_DEF_PATTERN = Pattern.compile("^\\[\\^\\s*(" + FOOTNOTE_ID + ")\\s*\\]:");
    private final FootnoteBlock block = new FootnoteBlock();
    private final FootnoteOptions options;
    private final int contentOffset;
    private BlockContent content = new BlockContent();

    public FootnoteBlockParser(FootnoteOptions options, int contentOffset) {
        this.options = options;
        this.contentOffset = contentOffset;
    }

    public BlockContent getBlockContent() {
        return this.content;
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockContinue tryContinue(ParserState state) {
        int nonSpaceIndex = state.getNextNonSpaceIndex();
        if (state.isBlank()) {
            if (this.block.getFirstChild() == null) {
                return BlockContinue.none();
            }
            return BlockContinue.atIndex((int)nonSpaceIndex);
        }
        if (state.getIndent() >= this.options.contentIndent) {
            int contentIndent = state.getIndex() + this.options.contentIndent;
            return BlockContinue.atIndex((int)contentIndent);
        }
        return BlockContinue.none();
    }

    public void addLine(ParserState state, BasedSequence line) {
        this.content.add(line, state.getIndent());
    }

    public void closeBlock(ParserState state) {
        this.block.setCharsFromContent();
        this.block.setFootnote((BasedSequence)((BasedSequence)this.block.getChars().subSequence(this.block.getClosingMarker().getEndOffset() - this.block.getStartOffset())).trimStart());
        FootnoteRepository footnoteMap = (FootnoteRepository)FootnoteExtension.FOOTNOTES.get((DataHolder)state.getProperties());
        footnoteMap.put(footnoteMap.normalizeKey((CharSequence)this.block.getText()), (Object)this.block);
        this.content = null;
    }

    public boolean isContainer() {
        return true;
    }

    public boolean canContain(ParserState state, BlockParser blockParser, Block block) {
        return true;
    }
}

