/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.utils.footnotes.internal;

import com.vladsch.flexmark.parser.LinkRefProcessor;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import org.springframework.lang.NonNull;
import run.halo.app.utils.footnotes.Footnote;
import run.halo.app.utils.footnotes.FootnoteBlock;
import run.halo.app.utils.footnotes.FootnoteExtension;
import run.halo.app.utils.footnotes.internal.FootnoteRepository;

public class FootnoteLinkRefProcessor
implements LinkRefProcessor {
    static final boolean WANT_EXCLAMATION_PREFIX = false;
    static final int BRACKET_NESTING_LEVEL = 0;
    private final FootnoteRepository footnoteRepository;

    public FootnoteLinkRefProcessor(Document document) {
        this.footnoteRepository = (FootnoteRepository)FootnoteExtension.FOOTNOTES.get((DataHolder)document);
    }

    public boolean getWantExclamationPrefix() {
        return false;
    }

    public int getBracketNestingLevel() {
        return 0;
    }

    public boolean isMatch(@NonNull BasedSequence nodeChars) {
        return nodeChars.length() >= 3 && nodeChars.charAt(0) == '[' && nodeChars.charAt(1) == '^' && nodeChars.endCharAt(1) == ']';
    }

    @NonNull
    public Node createNode(@NonNull BasedSequence nodeChars) {
        BasedSequence footnoteId = (BasedSequence)((BasedSequence)nodeChars.midSequence(2, -1)).trim();
        FootnoteBlock footnoteBlock = footnoteId.length() > 0 ? (FootnoteBlock)this.footnoteRepository.get((Object)footnoteId.toString()) : null;
        Footnote footnote = new Footnote(nodeChars.subSequence(0, 2), footnoteId, (BasedSequence)nodeChars.endSequence(1));
        footnote.setFootnoteBlock(footnoteBlock);
        if (footnoteBlock != null) {
            this.footnoteRepository.addFootnoteReference(footnoteBlock, footnote);
        }
        return footnote;
    }

    @NonNull
    public BasedSequence adjustInlineText(@NonNull Document document, @NonNull Node node) {
        assert (node instanceof Footnote);
        return ((Footnote)node).getText();
    }

    public boolean allowDelimiters(@NonNull BasedSequence chars, @NonNull Document document, @NonNull Node node) {
        return true;
    }

    public void updateNodeElements(@NonNull Document document, @NonNull Node node) {
    }
}

