/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.utils.footnotes.internal;

import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.NodeRepositoryFormatter;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.Nullable;
import run.halo.app.utils.footnotes.Footnote;
import run.halo.app.utils.footnotes.FootnoteBlock;
import run.halo.app.utils.footnotes.FootnoteExtension;
import run.halo.app.utils.footnotes.internal.FootnoteFormatOptions;
import run.halo.app.utils.footnotes.internal.FootnoteRepository;

public class FootnoteNodeFormatter
extends NodeRepositoryFormatter<FootnoteRepository, FootnoteBlock, Footnote> {
    public static final DataKey<Map<String, String>> FOOTNOTE_TRANSLATION_MAP = new DataKey("FOOTNOTE_TRANSLATION_MAP", new HashMap());
    public static final DataKey<Map<String, String>> FOOTNOTE_UNIQUIFICATION_MAP = new DataKey("FOOTNOTE_UNIQUIFICATION_MAP", new HashMap());
    private final FootnoteFormatOptions options;

    public FootnoteNodeFormatter(DataHolder options) {
        super(options, FOOTNOTE_TRANSLATION_MAP, FOOTNOTE_UNIQUIFICATION_MAP);
        this.options = new FootnoteFormatOptions(options);
    }

    public FootnoteRepository getRepository(DataHolder options) {
        return (FootnoteRepository)FootnoteExtension.FOOTNOTES.get(options);
    }

    public ElementPlacement getReferencePlacement() {
        return this.options.footnotePlacement;
    }

    public ElementPlacementSort getReferenceSort() {
        return this.options.footnoteSort;
    }

    public void renderReferenceBlock(FootnoteBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        ((MarkdownWriter)markdown.blankLine()).append((CharSequence)"[^");
        markdown.append((CharSequence)this.transformReferenceId(node.getText().toString(), context));
        markdown.append((CharSequence)"]: ");
        ((MarkdownWriter)markdown.pushPrefix()).addPrefix((CharSequence)"    ");
        context.renderChildren((Node)node);
        markdown.popPrefix();
        markdown.blankLine();
    }

    @Nullable
    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler(Footnote.class, (arg_0, arg_1, arg_2) -> this.render(arg_0, arg_1, arg_2)), new NodeFormattingHandler(FootnoteBlock.class, (arg_0, arg_1, arg_2) -> this.render(arg_0, arg_1, arg_2))));
    }

    @Nullable
    public Set<Class<?>> getNodeClasses() {
        if (this.options.footnotePlacement.isNoChange() || !this.options.footnoteSort.isUnused()) {
            return null;
        }
        return new HashSet(Arrays.asList(Footnote.class));
    }

    private void render(FootnoteBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.renderReference((Node)node, context, markdown);
    }

    private void render(Footnote node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append((CharSequence)"[^");
        if (context.isTransformingText()) {
            String referenceId = this.transformReferenceId(node.getText().toString(), context);
            context.nonTranslatingSpan((context1, markdown1) -> markdown1.append((CharSequence)referenceId));
        } else {
            markdown.append((CharSequence)node.getText());
        }
        markdown.append((CharSequence)"]");
    }
}

