/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.utils.footnotes.internal;

import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.PhasedNodeRenderer;
import com.vladsch.flexmark.html.renderer.RenderingPhase;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeVisitor;
import com.vladsch.flexmark.util.ast.VisitHandler;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.NonNull;
import run.halo.app.utils.footnotes.Footnote;
import run.halo.app.utils.footnotes.FootnoteBlock;
import run.halo.app.utils.footnotes.FootnoteExtension;
import run.halo.app.utils.footnotes.internal.FootnoteOptions;
import run.halo.app.utils.footnotes.internal.FootnoteRepository;

public class FootnoteNodeRenderer
implements PhasedNodeRenderer {
    private final FootnoteRepository footnoteRepository;
    private final FootnoteOptions options;
    private final boolean recheckUndefinedReferences;

    public FootnoteNodeRenderer(DataHolder options) {
        this.options = new FootnoteOptions(options);
        this.footnoteRepository = (FootnoteRepository)FootnoteExtension.FOOTNOTES.get(options);
        this.recheckUndefinedReferences = (Boolean)HtmlRenderer.RECHECK_UNDEFINED_REFERENCES.get(options);
        this.footnoteRepository.resolveFootnoteOrdinals();
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Arrays.asList(new NodeRenderingHandler(Footnote.class, (arg_0, arg_1, arg_2) -> this.render(arg_0, arg_1, arg_2)), new NodeRenderingHandler(FootnoteBlock.class, (arg_0, arg_1, arg_2) -> this.render(arg_0, arg_1, arg_2))));
    }

    public Set<RenderingPhase> getRenderingPhases() {
        HashSet<RenderingPhase> set = new HashSet<RenderingPhase>();
        set.add(RenderingPhase.BODY_TOP);
        set.add(RenderingPhase.BODY_BOTTOM);
        return set;
    }

    public void renderDocument(@NonNull NodeRendererContext context, @NonNull HtmlWriter html, @NonNull Document document, @NonNull RenderingPhase phase) {
        if (phase == RenderingPhase.BODY_TOP && this.recheckUndefinedReferences) {
            boolean[] hadNewFootnotes = new boolean[]{false};
            NodeVisitor visitor = new NodeVisitor(new VisitHandler[]{new VisitHandler(Footnote.class, node -> {
                FootnoteBlock footonoteBlock;
                if (!node.isDefined() && (footonoteBlock = node.getFootnoteBlock(this.footnoteRepository)) != null) {
                    this.footnoteRepository.addFootnoteReference(footonoteBlock, node);
                    node.setFootnoteBlock(footonoteBlock);
                    hadNewFootnotes[0] = true;
                }
            })});
            visitor.visit((Node)document);
            if (hadNewFootnotes[0]) {
                this.footnoteRepository.resolveFootnoteOrdinals();
            }
        }
        if (phase == RenderingPhase.BODY_BOTTOM && this.footnoteRepository.getReferencedFootnoteBlocks().size() > 0) {
            ((HtmlWriter)html.attr((CharSequence)"class", (CharSequence)"footnotes-sep")).withAttr().tagVoid((CharSequence)"hr");
            ((HtmlWriter)html.attr((CharSequence)"class", (CharSequence)"footnotes")).withAttr().tagIndent((CharSequence)"section", () -> ((HtmlWriter)html.attr((CharSequence)"class", (CharSequence)"footnotes-list")).withAttr().tagIndent((CharSequence)"ol", () -> {
                for (FootnoteBlock footnoteBlock : this.footnoteRepository.getReferencedFootnoteBlocks()) {
                    int footnoteOrdinal = footnoteBlock.getFootnoteOrdinal();
                    ((HtmlWriter)html.attr((CharSequence)"id", (CharSequence)("fn" + footnoteOrdinal))).attr((CharSequence)"class", (CharSequence)"footnote-item");
                    html.withAttr().tagIndent((CharSequence)"li", () -> {
                        context.renderChildren((Node)footnoteBlock);
                        int lineIndex = html.getLineCount() - 1;
                        BasedSequence line = html.getLine(lineIndex);
                        if (line.lastIndexOf((CharSequence)"</p>") > -1) {
                            int iMax = footnoteBlock.getFootnoteReferences();
                            for (int i = 0; i < iMax; ++i) {
                                StringBuilder sb = new StringBuilder();
                                sb.append(" <a href=\"#fnref").append(footnoteOrdinal).append(i == 0 ? "" : String.format(Locale.US, ":%d", i)).append("\"");
                                if (StringUtils.isNotBlank((CharSequence)this.options.footnoteBackLinkRefClass)) {
                                    sb.append(" class=\"").append(this.options.footnoteBackLinkRefClass).append("\"");
                                }
                                sb.append(">").append(this.options.footnoteBackRefString).append("</a>");
                                html.setLine(html.getLineCount() - 1, (CharSequence)"", (CharSequence)line.insert(line.lastIndexOf((CharSequence)"</p"), (CharSequence)sb.toString()));
                            }
                        } else {
                            int iMax = footnoteBlock.getFootnoteReferences();
                            for (int i = 0; i < iMax; ++i) {
                                html.attr((CharSequence)"href", (CharSequence)("#fnref" + footnoteOrdinal + (i == 0 ? "" : String.format(Locale.US, ":%d", i))));
                                if (StringUtils.isNotBlank((CharSequence)this.options.footnoteBackLinkRefClass)) {
                                    html.attr((CharSequence)"class", (CharSequence)this.options.footnoteBackLinkRefClass);
                                }
                                ((HtmlWriter)html.line()).withAttr().tag((CharSequence)"a");
                                html.raw((CharSequence)this.options.footnoteBackRefString);
                                html.tag((CharSequence)"/a");
                            }
                        }
                    });
                }
            }));
        }
    }

    private void render(FootnoteBlock node, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(Footnote node, NodeRendererContext context, HtmlWriter html) {
        FootnoteBlock footnoteBlock = node.getFootnoteBlock();
        if (footnoteBlock == null) {
            html.raw((CharSequence)"[^");
            context.renderChildren((Node)node);
            html.raw((CharSequence)"]");
        } else {
            int footnoteOrdinal = footnoteBlock.getFootnoteOrdinal();
            int i = node.getReferenceOrdinal();
            html.attr((CharSequence)"class", (CharSequence)"footnote-ref");
            html.srcPos(node.getChars()).withAttr().tag((CharSequence)"sup", false, false, () -> {
                String ordinal = footnoteOrdinal + (i == 0 ? "" : String.format(Locale.US, ":%d", i));
                html.attr((CharSequence)"id", (CharSequence)("fnref" + ordinal));
                html.attr((CharSequence)"href", (CharSequence)("#fn" + footnoteOrdinal));
                html.withAttr().tag((CharSequence)"a");
                html.raw((CharSequence)("[" + ordinal + "]"));
                html.tag((CharSequence)"/a");
            });
        }
    }
}

