/*
 * Decompiled with CFR 0.152.
 */
package run.halo.app.utils.footnotes.internal;

import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.KeepType;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeRepository;
import com.vladsch.flexmark.util.ast.NodeVisitor;
import com.vladsch.flexmark.util.ast.VisitHandler;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.lang.NonNull;
import run.halo.app.utils.footnotes.Footnote;
import run.halo.app.utils.footnotes.FootnoteBlock;
import run.halo.app.utils.footnotes.FootnoteExtension;

public class FootnoteRepository
extends NodeRepository<FootnoteBlock> {
    private final ArrayList<FootnoteBlock> referencedFootnoteBlocks = new ArrayList();

    public static void resolveFootnotes(Document document) {
        FootnoteRepository footnoteRepository = (FootnoteRepository)FootnoteExtension.FOOTNOTES.get((DataHolder)document);
        boolean[] hadNewFootnotes = new boolean[]{false};
        NodeVisitor visitor = new NodeVisitor(new VisitHandler[]{new VisitHandler(Footnote.class, node -> {
            FootnoteBlock footonoteBlock;
            if (!node.isDefined() && (footonoteBlock = node.getFootnoteBlock(footnoteRepository)) != null) {
                footnoteRepository.addFootnoteReference(footonoteBlock, node);
                node.setFootnoteBlock(footonoteBlock);
                hadNewFootnotes[0] = true;
            }
        })});
        visitor.visit((Node)document);
        if (hadNewFootnotes[0]) {
            footnoteRepository.resolveFootnoteOrdinals();
        }
    }

    public void addFootnoteReference(FootnoteBlock footnoteBlock, Footnote footnote) {
        if (!footnoteBlock.isReferenced()) {
            this.referencedFootnoteBlocks.add(footnoteBlock);
        }
        footnoteBlock.setFirstReferenceOffset(footnote.getStartOffset());
        int referenceOrdinal = footnoteBlock.getFootnoteReferences();
        footnoteBlock.setFootnoteReferences(referenceOrdinal + 1);
        footnote.setReferenceOrdinal(referenceOrdinal);
    }

    public void resolveFootnoteOrdinals() {
        Collections.sort(this.referencedFootnoteBlocks, (f1, f2) -> f1.getFirstReferenceOffset() - f2.getFirstReferenceOffset());
        int ordinal = 0;
        for (FootnoteBlock footnoteBlock : this.referencedFootnoteBlocks) {
            footnoteBlock.setFootnoteOrdinal(++ordinal);
        }
    }

    public List<FootnoteBlock> getReferencedFootnoteBlocks() {
        return this.referencedFootnoteBlocks;
    }

    public FootnoteRepository(DataHolder options) {
        super((KeepType)FootnoteExtension.FOOTNOTES_KEEP.get(options));
    }

    @NonNull
    public DataKey<FootnoteRepository> getDataKey() {
        return FootnoteExtension.FOOTNOTES;
    }

    @NonNull
    public DataKey<KeepType> getKeepDataKey() {
        return FootnoteExtension.FOOTNOTES_KEEP;
    }

    @NonNull
    public Set<FootnoteBlock> getReferencedElements(Node parent) {
        HashSet<FootnoteBlock> references = new HashSet<FootnoteBlock>();
        this.visitNodes(parent, value -> {
            FootnoteBlock reference;
            if (value instanceof Footnote && (reference = ((Footnote)value).getReferenceNode(this)) != null) {
                references.add(reference);
            }
        }, new Class[]{Footnote.class});
        return references;
    }
}

