/*
 * Decompiled with CFR 0.152.
 */
package com.linln.component.excel;

import com.linln.common.utils.EhCacheUtil;
import com.linln.common.utils.HttpServletUtil;
import com.linln.component.excel.annotation.Excel;
import com.linln.component.excel.enums.ExcelType;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.BeanUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ExcelUtil {
    private static int dataRow = 2;
    private static Cache dictCache = EhCacheUtil.getDictCache();

    private static XSSFCellStyle getCellStyle(XSSFWorkbook workbook) {
        XSSFCellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        XSSFFont font = workbook.createFont();
        font.setFontName("Microsoft YaHei UI");
        cellStyle.setFont((Font)font);
        return cellStyle;
    }

    private static XSSFWorkbook getCommon(String sheetTitle, List<Field> fields) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet(sheetTitle);
        for (int i = 0; i < fields.size(); ++i) {
            sheet.setColumnWidth(i, 4096);
        }
        XSSFCellStyle cellStyle = ExcelUtil.getCellStyle(workbook);
        XSSFCellStyle titleStyle = workbook.createCellStyle();
        titleStyle.cloneStyleFrom((CellStyle)cellStyle);
        titleStyle.setAlignment(HorizontalAlignment.CENTER);
        titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFFont titleFont = workbook.createFont();
        titleFont.setFontName(cellStyle.getFont().getFontName());
        titleFont.setBold(true);
        titleFont.setFontHeight(14.0);
        titleStyle.setFont((Font)titleFont);
        XSSFCellStyle thStyle = workbook.createCellStyle();
        thStyle.cloneStyleFrom((CellStyle)titleStyle);
        thStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        thStyle.setFillForegroundColor(IndexedColors.GREY_50_PERCENT.getIndex());
        XSSFFont thFont = workbook.createFont();
        thFont.setFontName(cellStyle.getFont().getFontName());
        thFont.setBold(titleFont.getBold());
        thFont.setColor(IndexedColors.WHITE.getIndex());
        thStyle.setFont((Font)thFont);
        XSSFRow titleRow = sheet.createRow(0);
        XSSFRow thsRow = sheet.createRow(1);
        for (int i = 0; i < fields.size(); ++i) {
            Excel excel = fields.get(i).getAnnotation(Excel.class);
            XSSFCell title = titleRow.createCell(i);
            title.setCellStyle((CellStyle)titleStyle);
            XSSFCell th = thsRow.createCell(i);
            th.setCellValue(excel.value());
            th.setCellStyle((CellStyle)thStyle);
        }
        titleRow.setHeight((short)520);
        XSSFCell titleCell = titleRow.createCell(0);
        titleCell.setCellValue(sheetTitle);
        titleCell.setCellStyle((CellStyle)titleStyle);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, fields.size() - 1));
        return workbook;
    }

    private static List<Field> getExcelList(Class<?> entity, ExcelType type) {
        Field[] fields;
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field field : fields = entity.getDeclaredFields()) {
            ExcelType fieldType;
            if (!field.isAnnotationPresent(Excel.class) || !(fieldType = field.getAnnotation(Excel.class).type()).equals((Object)ExcelType.ALL) && !fieldType.equals((Object)type)) continue;
            list.add(field);
        }
        return list;
    }

    private static List<String> getFieldName(List<Field> fields) {
        ArrayList<String> list = new ArrayList<String>();
        for (Field field : fields) {
            list.add(field.getName());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void download(XSSFWorkbook workbook, String fileName) {
        try {
            fileName = URLEncoder.encode(fileName + ".xlsx", "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        HttpServletResponse response = HttpServletUtil.getResponse();
        response.setCharacterEncoding("utf-8");
        response.setContentType("multipart/form-data");
        response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
        ServletOutputStream ros = null;
        try {
            ros = response.getOutputStream();
            workbook.write((OutputStream)ros);
            ros.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (ros != null) {
                try {
                    ros.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (workbook != null) {
                try {
                    workbook.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void genTemplate(Class<?> entity) {
        Excel excel = entity.getAnnotation(Excel.class);
        if (excel != null) {
            ExcelUtil.genTemplate(entity, excel.value());
        } else {
            ExcelUtil.genTemplate(entity, entity.getSimpleName());
        }
    }

    public static void genTemplate(Class<?> entity, String sheetTitle) {
        XSSFWorkbook workbook = ExcelUtil.getCommon(sheetTitle, ExcelUtil.getExcelList(entity, ExcelType.IMPORT));
        ExcelUtil.download(workbook, sheetTitle + "\u6a21\u677f");
    }

    public static <T> void exportExcel(Class<?> entity, List<T> list) {
        Excel excel = entity.getAnnotation(Excel.class);
        if (excel != null) {
            ExcelUtil.exportExcel(entity, list, excel.value());
        } else {
            ExcelUtil.exportExcel(entity, list, entity.getSimpleName());
        }
    }

    public static <T> void exportExcel(Class<?> entity, List<T> list, String sheetTitle) {
        List<Field> fields = ExcelUtil.getExcelList(entity, ExcelType.EXPORT);
        List<String> fns = ExcelUtil.getFieldName(fields);
        XSSFWorkbook workbook = ExcelUtil.getCommon(sheetTitle, fields);
        XSSFSheet sheet = workbook.getSheet(sheetTitle);
        XSSFCellStyle cellStyle = ExcelUtil.getCellStyle(workbook);
        XSSFCellStyle dateStyle = workbook.createCellStyle();
        dateStyle.cloneStyleFrom((CellStyle)cellStyle);
        XSSFDataFormat format = workbook.createDataFormat();
        dateStyle.setDataFormat(format.getFormat("yyyy-MM-dd HH:mm:ss"));
        for (int i = 0; i < list.size(); ++i) {
            XSSFRow row = sheet.createRow(i + dataRow);
            T item = list.get(i);
            try {
                BeanInfo bi = Introspector.getBeanInfo(item.getClass());
                for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                    if (!fns.contains(pd.getName())) continue;
                    Object value = pd.getReadMethod().invoke(item, (Object[])null);
                    int index = fns.indexOf(pd.getName());
                    XSSFCell cell = row.createCell(index);
                    if (value != null) {
                        String joinField;
                        Element dictEle;
                        Excel excel = fields.get(index).getAnnotation(Excel.class);
                        String dict = excel.dict();
                        if (!dict.isEmpty() && (dictEle = dictCache.get((Serializable)((Object)dict))) != null) {
                            Map dictValue = (Map)dictEle.getObjectValue();
                            value = dictValue.get(String.valueOf(value));
                        }
                        if (!(joinField = excel.joinField()).isEmpty()) {
                            PropertyDescriptor sourcePd = BeanUtils.getPropertyDescriptor(value.getClass(), (String)joinField);
                            value = sourcePd.getReadMethod().invoke(value, (Object[])null);
                        }
                        if (value instanceof Number) {
                            cell.setCellValue(Double.valueOf(String.valueOf(value)).doubleValue());
                        } else {
                            if (value instanceof Date) {
                                cell.setCellValue((Date)value);
                                cell.setCellStyle((CellStyle)dateStyle);
                                continue;
                            }
                            cell.setCellValue(String.valueOf(value));
                        }
                    }
                    cell.setCellStyle((CellStyle)cellStyle);
                }
                continue;
            }
            catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
                String message = "\u5bfc\u5165\u5931\u8d25\uff1a\u5b57\u6bb5\u540d\u79f0\u5339\u914d\u5931\u8d25\uff01";
                throw new IllegalArgumentException(message, e);
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        ExcelUtil.download(workbook, sheetTitle + dateFormat.format(new Date()));
    }

    public static <T> List<T> importExcel(Class<T> entity, InputStream inputStream) {
        ArrayList<T> list = new ArrayList<T>();
        List<String> fns = ExcelUtil.getFieldName(ExcelUtil.getExcelList(entity, ExcelType.IMPORT));
        XSSFWorkbook workbook = null;
        try {
            ZipSecureFile.setMinInflateRatio((double)-1.0);
            workbook = new XSSFWorkbook(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Assert.notNull((Object)workbook, (String)"\u8be5\u53d6Excel\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\uff01");
        XSSFSheet sheet = workbook.getSheetAt(0);
        Assert.notNull((Object)sheet, (String)"\u8be5Excel\u6587\u4ef6\u6ca1\u6709\u5de5\u4f5c\u533a\uff0c\u65e0\u6cd5\u8bfb\u53d6\u6570\u636e\uff01");
        int count = 0;
        for (Row row : sheet) {
            if (count < dataRow) {
                ++count;
                continue;
            }
            int end = row.getLastCellNum();
            String[] rowData = new String[end];
            for (int i = 0; i < end; ++i) {
                Cell cell = row.getCell(i);
                if (cell != null) {
                    if (cell.getCellType() == CellType.NUMERIC && HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                        Date date = cell.getDateCellValue();
                        rowData[i] = String.valueOf(date.getTime());
                        continue;
                    }
                    cell.setCellType(CellType.STRING);
                    rowData[i] = cell.getStringCellValue();
                    continue;
                }
                rowData[i] = null;
            }
            try {
                T newInstance = entity.newInstance();
                BeanInfo bi = Introspector.getBeanInfo(entity);
                for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                    String value;
                    Method writeMethod;
                    if (!fns.contains(pd.getName()) || (writeMethod = pd.getWriteMethod()) == null) continue;
                    if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                        writeMethod.setAccessible(true);
                    }
                    if (StringUtils.isEmpty((Object)(value = rowData[fns.indexOf(pd.getName())]))) continue;
                    Class<?> propertyType = pd.getPropertyType();
                    if (String.class == propertyType) {
                        writeMethod.invoke(newInstance, value);
                        continue;
                    }
                    if (Integer.class == propertyType) {
                        writeMethod.invoke(newInstance, Integer.valueOf(value));
                        continue;
                    }
                    if (Long.class == propertyType) {
                        writeMethod.invoke(newInstance, Double.valueOf(value).longValue());
                        continue;
                    }
                    if (Float.class == propertyType) {
                        writeMethod.invoke(newInstance, Float.valueOf(value));
                        continue;
                    }
                    if (Short.class == propertyType) {
                        writeMethod.invoke(newInstance, Short.valueOf(value));
                        continue;
                    }
                    if (Double.class == propertyType) {
                        writeMethod.invoke(newInstance, Double.valueOf(value));
                        continue;
                    }
                    if (Character.class == propertyType) {
                        if (value == null || value.length() <= 0) continue;
                        writeMethod.invoke(newInstance, Character.valueOf(value.charAt(0)));
                        continue;
                    }
                    if (Date.class == propertyType) {
                        writeMethod.invoke(newInstance, new Date(Long.parseLong(value)));
                        continue;
                    }
                    if (BigDecimal.class != propertyType) continue;
                    writeMethod.invoke(newInstance, new BigDecimal(value));
                }
                list.add(newInstance);
            }
            catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
                String message = "\u5bfc\u5165\u5931\u8d25\uff1a\u5b57\u6bb5\u540d\u79f0\u5339\u914d\u5931\u8d25\uff01";
                throw new IllegalArgumentException(message, e);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        return list;
    }
}

