/*
 * Decompiled with CFR 0.152.
 */
package com.linln.component.actionLog.action;

import com.linln.common.utils.SpringContextUtil;
import com.linln.common.vo.ResultVo;
import com.linln.component.actionLog.action.SaveAction;
import com.linln.component.actionLog.action.base.BaseActionMap;
import com.linln.component.actionLog.action.base.ResetLog;
import com.linln.component.actionLog.action.model.BusinessMethod;
import com.linln.component.actionLog.action.model.LoginMethod;
import com.linln.modules.system.domain.ActionLog;
import com.linln.modules.system.domain.User;
import com.linln.modules.system.service.ActionLogService;
import java.util.List;
import javax.persistence.Table;
import org.springframework.beans.BeanUtils;

public class UserAction
extends BaseActionMap {
    public static final String USER_LOGIN = "user_login";
    public static final String USER_SAVE = "user_save";
    public static final String EDIT_PWD = "edit_pwd";
    public static final String EDIT_ROLE = "edit_role";

    @Override
    public void init() {
        this.putMethod(USER_LOGIN, new LoginMethod("\u7528\u6237\u767b\u5f55", "userLogin"));
        this.putMethod(USER_SAVE, new BusinessMethod("\u7528\u6237\u7ba1\u7406", "userSave"));
        this.putMethod(EDIT_PWD, new BusinessMethod("\u7528\u6237\u5bc6\u7801", "editPwd"));
        this.putMethod(EDIT_ROLE, new BusinessMethod("\u89d2\u8272\u5206\u914d", "editRole"));
    }

    public void userLogin(ResetLog resetLog) {
        ActionLog actionLog = resetLog.getActionLog();
        if (resetLog.isSuccess()) {
            actionLog.setMessage("\u540e\u53f0\u767b\u5f55\u6210\u529f");
        } else {
            String username = (String)resetLog.getParam("username");
            ResultVo resultVo = (ResultVo)resetLog.getRetValue();
            actionLog.setOperName(username);
            actionLog.setMessage(String.format("\u540e\u53f0\u767b\u5f55\u5931\u8d25\uff1a[%s]%s", username, resultVo.getMsg()));
        }
    }

    public void userSave(ResetLog resetLog) {
        resetLog.getActionLog().setMessage("\u7528\u6237\u6210\u529f\uff1a${username}");
        SaveAction.defaultMethod(resetLog);
    }

    public void editPwd(ResetLog resetLog) {
        List users = (List)resetLog.getParam("users");
        Table table = User.class.getAnnotation(Table.class);
        String message = "\u4fee\u6539\u7528\u6237\u5bc6\u7801\u6210\u529f";
        if (!resetLog.isSuccess()) {
            message = "\u4fee\u6539\u7528\u6237\u5bc6\u7801\u5931\u8d25";
        }
        ActionLogService actionLogService = (ActionLogService)SpringContextUtil.getBean(ActionLogService.class);
        String finalMessage = message;
        users.forEach(user -> {
            ActionLog actionLog = new ActionLog();
            BeanUtils.copyProperties((Object)resetLog.getActionLog(), (Object)actionLog);
            actionLog.setModel(table.name());
            actionLog.setRecordId(user.getId());
            actionLog.setMessage(finalMessage + user.getUsername());
            actionLogService.save(actionLog);
        });
        resetLog.setRecord(false);
    }

    public void editRole(ResetLog resetLog) {
        User user = (User)resetLog.getParam("user");
        Table table = User.class.getAnnotation(Table.class);
        resetLog.getActionLog().setModel(table.name());
        resetLog.getActionLog().setRecordId(user.getId());
        if (resetLog.isSuccess()) {
            resetLog.getActionLog().setMessage("\u89d2\u8272\u5206\u914d\u6210\u529f\uff1a" + user.getUsername());
        } else {
            resetLog.getActionLog().setMessage("\u89d2\u8272\u5206\u914d\u5931\u8d25\uff1a" + user.getUsername());
        }
    }
}

