/*
 * Decompiled with CFR 0.152.
 */
package com.linln.component.actionLog.action.base;

import com.linln.common.enums.ResultEnum;
import com.linln.common.utils.EntityBeanUtil;
import com.linln.common.vo.ResultVo;
import com.linln.component.actionLog.annotation.EntityParam;
import com.linln.component.shiro.ShiroUtil;
import com.linln.modules.system.domain.ActionLog;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class ResetLog {
    private Object retValue;
    private ActionLog actionLog;
    private JoinPoint joinPoint;
    private Boolean record = true;
    private static final Pattern FILL_PATTERN = Pattern.compile("\\$\\{[a-zA-Z0-9]+\\}");

    public boolean isResultVo() {
        return this.retValue instanceof ResultVo;
    }

    public boolean isSuccess() {
        return this.retValue instanceof ResultVo && ((ResultVo)this.retValue).getCode().equals(ResultEnum.SUCCESS.getCode());
    }

    public boolean isSuccessRecord() {
        this.record = this.retValue instanceof ResultVo && ((ResultVo)this.retValue).getCode().equals(ResultEnum.SUCCESS.getCode());
        return this.record;
    }

    public Object getParam(String name) {
        Object[] args = this.joinPoint.getArgs();
        if (args.length > 0) {
            MethodSignature methodSignature = (MethodSignature)this.joinPoint.getSignature();
            String[] parameterNames = methodSignature.getParameterNames();
            for (int i = 0; i < parameterNames.length; ++i) {
                if (!parameterNames[i].equals(name)) continue;
                return args[i];
            }
        }
        return null;
    }

    public Object getEntityParam() {
        Object[] args = this.joinPoint.getArgs();
        if (args.length > 0) {
            MethodSignature signature = (MethodSignature)this.joinPoint.getSignature();
            Method method = signature.getMethod();
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            for (int i = 0; i < parameterAnnotations.length; ++i) {
                for (int j = 0; j < parameterAnnotations[i].length; ++j) {
                    if (!(parameterAnnotations[i][j] instanceof EntityParam)) continue;
                    return args[i];
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fillRule(Object beanObject, String content) {
        Matcher matcher = FILL_PATTERN.matcher(content);
        while (matcher.find()) {
            String matchWord = matcher.group(0);
            String property = matchWord.substring(2, matchWord.length() - 1);
            String fill = null;
            try {
                fill = String.valueOf(EntityBeanUtil.getField((Object)beanObject, (String)property));
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {}
            continue;
            finally {
                content = content.replace(matchWord, fill);
            }
        }
        return content;
    }

    public String getUsername() {
        return ShiroUtil.getSubject().getUsername();
    }

    public String getNickname() {
        return ShiroUtil.getSubject().getNickname();
    }

    public String getDatetime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(new Date());
    }

    public String getDatetime(String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.format(new Date());
    }

    public Object getRetValue() {
        return this.retValue;
    }

    public ActionLog getActionLog() {
        return this.actionLog;
    }

    public JoinPoint getJoinPoint() {
        return this.joinPoint;
    }

    public Boolean getRecord() {
        return this.record;
    }

    public void setRetValue(Object retValue) {
        this.retValue = retValue;
    }

    public void setActionLog(ActionLog actionLog) {
        this.actionLog = actionLog;
    }

    public void setJoinPoint(JoinPoint joinPoint) {
        this.joinPoint = joinPoint;
    }

    public void setRecord(Boolean record) {
        this.record = record;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResetLog)) {
            return false;
        }
        ResetLog other = (ResetLog)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$retValue = this.getRetValue();
        Object other$retValue = other.getRetValue();
        if (this$retValue == null ? other$retValue != null : !this$retValue.equals(other$retValue)) {
            return false;
        }
        ActionLog this$actionLog = this.getActionLog();
        ActionLog other$actionLog = other.getActionLog();
        if (this$actionLog == null ? other$actionLog != null : !this$actionLog.equals(other$actionLog)) {
            return false;
        }
        JoinPoint this$joinPoint = this.getJoinPoint();
        JoinPoint other$joinPoint = other.getJoinPoint();
        if (this$joinPoint == null ? other$joinPoint != null : !this$joinPoint.equals(other$joinPoint)) {
            return false;
        }
        Boolean this$record = this.getRecord();
        Boolean other$record = other.getRecord();
        return !(this$record == null ? other$record != null : !((Object)this$record).equals(other$record));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResetLog;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $retValue = this.getRetValue();
        result = result * 59 + ($retValue == null ? 43 : $retValue.hashCode());
        ActionLog $actionLog = this.getActionLog();
        result = result * 59 + ($actionLog == null ? 43 : $actionLog.hashCode());
        JoinPoint $joinPoint = this.getJoinPoint();
        result = result * 59 + ($joinPoint == null ? 43 : $joinPoint.hashCode());
        Boolean $record = this.getRecord();
        result = result * 59 + ($record == null ? 43 : ((Object)$record).hashCode());
        return result;
    }

    public String toString() {
        return "ResetLog(retValue=" + this.getRetValue() + ", actionLog=" + this.getActionLog() + ", joinPoint=" + this.getJoinPoint() + ", record=" + this.getRecord() + ")";
    }
}

