/*
 * Decompiled with CFR 0.152.
 */
package com.linln.component.actionLog.annotation;

import com.linln.common.utils.SpringContextUtil;
import com.linln.component.actionLog.action.base.BaseActionMap;
import com.linln.component.actionLog.action.base.ResetLog;
import com.linln.component.actionLog.action.model.ActionModel;
import com.linln.component.actionLog.action.model.BusinessMethod;
import com.linln.component.actionLog.action.model.BusinessType;
import com.linln.component.actionLog.annotation.ActionLog;
import com.linln.component.shiro.ShiroUtil;
import com.linln.modules.system.service.ActionLogService;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Aspect
@Component
public class ActionLogAop {
    private static final Logger log = LoggerFactory.getLogger(ActionLogAop.class);
    private static final String DEFAULT_ACTION_NAME = "default";

    @Pointcut(value="@annotation(com.linln.component.actionLog.annotation.ActionLog)")
    public void actionLog() {
    }

    @Around(value="actionLog()")
    public Object recordLog(ProceedingJoinPoint point) throws Throwable {
        Object proceed = point.proceed();
        Method targetMethod = ((MethodSignature)point.getSignature()).getMethod();
        ActionLog anno = targetMethod.getAnnotation(ActionLog.class);
        String name = anno.name();
        String message = anno.message();
        String key = anno.key();
        Class<? extends BaseActionMap> action = anno.action();
        BaseActionMap instance = action.newInstance();
        Object actionModel = instance.get(!key.isEmpty() ? key : DEFAULT_ACTION_NAME);
        Assert.notNull((Object)actionModel, (String)("\u65e0\u6cd5\u83b7\u53d6\u65e5\u5fd7\u7684\u884c\u4e3a\u65b9\u6cd5\uff0c\u8bf7\u68c0\u67e5\uff1a" + point.getSignature()));
        com.linln.modules.system.domain.ActionLog actionLog = new com.linln.modules.system.domain.ActionLog();
        actionLog.setIpaddr(ShiroUtil.getIp());
        actionLog.setClazz(point.getTarget().getClass().getName());
        actionLog.setMethod(targetMethod.getName());
        actionLog.setType(((ActionModel)actionModel).getType());
        actionLog.setName(!name.isEmpty() ? name : ((ActionModel)actionModel).getName());
        actionLog.setMessage(message);
        actionLog.setOperBy(ShiroUtil.getSubject());
        if (ShiroUtil.getSubject() != null) {
            actionLog.setOperName(ShiroUtil.getSubject().getNickname());
        }
        if (actionModel instanceof BusinessType) {
            actionLog.setMessage(((BusinessType)actionModel).getMessage());
        } else {
            ResetLog resetLog = new ResetLog();
            resetLog.setActionLog(actionLog);
            resetLog.setRetValue(proceed);
            resetLog.setJoinPoint((JoinPoint)point);
            try {
                Method method = action.getDeclaredMethod(((BusinessMethod)actionModel).getMethod(), ResetLog.class);
                method.invoke((Object)instance, resetLog);
                if (!resetLog.getRecord().booleanValue()) {
                    return proceed;
                }
            }
            catch (NoSuchMethodException e) {
                log.error("\u83b7\u53d6\u884c\u4e3a\u5bf9\u8c61\u65b9\u6cd5\u9519\u8bef\uff01\u8bf7\u68c0\u67e5\u65b9\u6cd5\u540d\u79f0\u662f\u5426\u6b63\u786e\uff01", (Throwable)e);
                e.printStackTrace();
            }
        }
        ActionLogService actionLogService = (ActionLogService)SpringContextUtil.getBean(ActionLogService.class);
        actionLogService.save(actionLog);
        return proceed;
    }
}

