/*
 * Decompiled with CFR 0.152.
 */
package com.linln.common.config;

import com.linln.common.config.properties.ProjectProperties;
import com.linln.common.xss.XssFilter;
import java.util.HashMap;
import javax.servlet.Filter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class XssFilterConfig {
    private static final int FILTER_ORDER = 1;

    @Bean
    public FilterRegistrationBean xssFilterRegistrationBean(ProjectProperties properties) {
        ProjectProperties.Xxs propertiesXxs = properties.getXxs();
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new XssFilter());
        registration.setOrder(1);
        registration.setEnabled(propertiesXxs.isEnabled());
        registration.addUrlPatterns(propertiesXxs.getUrlPatterns().split(","));
        HashMap<String, String> initParameters = new HashMap<String, String>(16);
        initParameters.put("excludes", propertiesXxs.getExcludes());
        registration.setInitParameters(initParameters);
        return registration;
    }
}

