/*
 * Decompiled with CFR 0.152.
 */
package com.linln.common.data;

import com.linln.common.utils.HttpServletUtil;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;

public class PageSort {
    private static final Integer PAGE_SIZE_DEF = 10;
    private static final String ORDER_BY_COLUMN_DEF = "createDate";
    private static final Sort.Direction SORT_DIRECTION = Sort.Direction.DESC;

    public static PageRequest pageRequest() {
        return PageSort.pageRequest(PAGE_SIZE_DEF, ORDER_BY_COLUMN_DEF, SORT_DIRECTION);
    }

    public static PageRequest pageRequest(Sort.Direction sortDirection) {
        return PageSort.pageRequest(PAGE_SIZE_DEF, ORDER_BY_COLUMN_DEF, sortDirection);
    }

    public static PageRequest pageRequest(String orderByColumnDef, Sort.Direction sortDirection) {
        return PageSort.pageRequest(PAGE_SIZE_DEF, orderByColumnDef, sortDirection);
    }

    public static PageRequest pageRequest(Integer pageSizeDef, String orderByColumnDef, Sort.Direction sortDirection) {
        Integer pageIndex = HttpServletUtil.getParameterInt("page", 1);
        Integer pageSize = HttpServletUtil.getParameterInt("size", pageSizeDef);
        String orderByColumn = HttpServletUtil.getParameter("orderByColumn", orderByColumnDef);
        String direction = HttpServletUtil.getParameter("isAsc", sortDirection.toString());
        Sort sort = new Sort(Sort.Direction.fromString((String)direction), new String[]{orderByColumn});
        return PageRequest.of((int)(pageIndex - 1), (int)pageSize, (Sort)sort);
    }
}

