/*
 * Decompiled with CFR 0.152.
 */
package com.linln.common.data;

import com.linln.common.enums.ResultEnum;
import com.linln.common.enums.StatusEnum;
import com.linln.common.exception.ResultException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class QuerySpec {
    public static final Long EQUAL = 0L;
    public static final Long LIKE = 1L;
    public static final Long LEFT_LIKE = 2L;
    public static final Long RIGHT_LIKE = 3L;
    public static final Long NOT_EQUAL = 4L;
    public static final Long GT = 5L;
    public static final Long GE = 6L;
    public static final Long LT = 7L;
    public static final Long LE = 8L;
    public static final Long IN = 9L;
    public static final Long BETWEEN = 10L;
    private Map<String, Long> fieldRules = new HashMap<String, Long>();
    private String[] ignoredPaths;
    private Map<String, List<Object>> inValues = new HashMap<String, List<Object>>();
    private Map<String, Long[]> betweenValues = new HashMap<String, Long[]>();
    private String status = "status";

    private QuerySpec() {
    }

    public static QuerySpec matching() {
        return new QuerySpec();
    }

    public QuerySpec withMatcher(String propertyPath, Long regulation) {
        this.fieldRules.put(propertyPath, regulation);
        return this;
    }

    public QuerySpec withMatcherIn(String propertyPath, List<Object> inValueList) {
        this.fieldRules.put(propertyPath, IN);
        this.inValues.put(propertyPath, inValueList);
        return this;
    }

    public QuerySpec withMatcherBetween(String propertyPath, Long x, Long y) {
        this.fieldRules.put(propertyPath, BETWEEN);
        this.betweenValues.put(propertyPath, new Long[]{x, y});
        return this;
    }

    public QuerySpec withIgnorePaths(String ... ignoredPaths) {
        this.ignoredPaths = ignoredPaths;
        return this;
    }

    private Map<String, Long> getFieldRules() {
        return this.fieldRules;
    }

    private List<String> getIgnoredPaths() {
        return Arrays.asList(this.ignoredPaths);
    }

    private Map<String, List<Object>> getInValues() {
        return this.inValues;
    }

    private Map<String, Long[]> getBetweenValues() {
        return this.betweenValues;
    }

    public static <T> Specification<T> of(final T probe, final QuerySpec querySpec) {
        final Map<String, Long> fieldRules = querySpec.getFieldRules();
        final List<String> ignoredPaths = querySpec.getIgnoredPaths();
        final Map<String, List<Object>> inValues = querySpec.getInValues();
        final Map<String, Long[]> betweenValues = querySpec.getBetweenValues();
        Specification specification = new Specification<T>(){

            public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                ArrayList<Object> preList = new ArrayList<Object>();
                try {
                    BeanInfo bi = Introspector.getBeanInfo(probe.getClass());
                    for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                        Object value = pd.getReadMethod().invoke(probe, (Object[])null);
                        if (value instanceof Class || value == null || ignoredPaths.contains(pd.getName())) continue;
                        if (querySpec.status.equals(pd.getName()) && StatusEnum.DELETE.getCode().equals(Byte.valueOf(String.valueOf(value)))) {
                            throw new ResultException(ResultEnum.STATUS_ERROR);
                        }
                        if (fieldRules.containsKey(pd.getName())) {
                            Long regulation = (Long)fieldRules.get(pd.getName());
                            if (regulation.equals(EQUAL)) {
                                preList.add(cb.equal(root.get(pd.getName()).as(value.getClass()), value));
                                continue;
                            }
                            if (regulation.equals(LIKE)) {
                                preList.add(cb.like(root.get(pd.getName()).as(String.class), "%" + String.valueOf(value) + "%"));
                                continue;
                            }
                            if (regulation.equals(LEFT_LIKE)) {
                                preList.add(cb.like(root.get(pd.getName()).as(String.class), "%" + String.valueOf(value)));
                                continue;
                            }
                            if (regulation.equals(RIGHT_LIKE)) {
                                preList.add(cb.like(root.get(pd.getName()).as(String.class), String.valueOf(value) + "%"));
                                continue;
                            }
                            if (regulation.equals(NOT_EQUAL)) {
                                preList.add(cb.notEqual(root.get(pd.getName()).as(value.getClass()), value));
                                continue;
                            }
                            if (regulation.equals(GT)) {
                                preList.add(cb.gt(root.get(pd.getName()).as(Long.class), (Number)Long.valueOf(String.valueOf(value))));
                                continue;
                            }
                            if (regulation.equals(GE)) {
                                preList.add(cb.ge(root.get(pd.getName()).as(Long.class), (Number)Long.valueOf(String.valueOf(value))));
                                continue;
                            }
                            if (regulation.equals(LT)) {
                                preList.add(cb.lt(root.get(pd.getName()).as(Long.class), (Number)Long.valueOf(String.valueOf(value))));
                                continue;
                            }
                            if (regulation.equals(LE)) {
                                preList.add(cb.le(root.get(pd.getName()).as(Long.class), (Number)Long.valueOf(String.valueOf(value))));
                                continue;
                            }
                            if (regulation.equals(IN)) {
                                CriteriaBuilder.In in = cb.in((Expression)root.get(pd.getName()));
                                List inList = (List)inValues.get(pd.getName());
                                if (inList == null) continue;
                                inList.forEach(arg_0 -> ((CriteriaBuilder.In)in).value(arg_0));
                                preList.add(in);
                                continue;
                            }
                            if (!regulation.equals(BETWEEN)) continue;
                            Long[] between = (Long[])betweenValues.get(pd.getName());
                            preList.add(cb.between((Expression)root.get(pd.getName()), (Comparable)between[0], (Comparable)between[1]));
                            continue;
                        }
                        preList.add(cb.equal(root.get(pd.getName()).as(value.getClass()), value));
                    }
                }
                catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalArgumentException("\u83b7\u53d6\u5b9e\u4f53\u7c7b\u6570\u636e\u65f6\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u5b9e\u4f53\u7c7bBean\u683c\u5f0f\u662f\u5426\u89c4\u8303\uff01", e);
                }
                Predicate[] pres = new Predicate[preList.size()];
                return query.where(preList.toArray(pres)).getRestriction();
            }
        };
        return specification;
    }
}

