/*
 * Decompiled with CFR 0.152.
 */
package com.linln.common.exception;

import com.linln.common.exception.ResultException;
import com.linln.common.exception.advice.ResultExceptionAdvice;
import com.linln.common.utils.ResultVoUtil;
import com.linln.common.utils.SpringContextUtil;
import com.linln.common.vo.ResultVo;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ResultExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ResultExceptionHandler.class);

    @ExceptionHandler(value={ResultException.class})
    @ResponseBody
    public ResultVo resultException(ResultException e) {
        return ResultVoUtil.error(e.getCode(), e.getMessage());
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseBody
    public ResultVo bindException(BindException e) {
        BindingResult bindingResult = e.getBindingResult();
        return ResultVoUtil.error(Objects.requireNonNull(bindingResult.getFieldError()).getDefaultMessage());
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseBody
    public ResultVo runtimeException(RuntimeException e) {
        ResultExceptionAdvice resultExceptionAdvice = SpringContextUtil.getBean(ResultExceptionAdvice.class);
        resultExceptionAdvice.runtimeException(e);
        log.error("\u3010\u7cfb\u7edf\u5f02\u5e38\u3011", (Throwable)e);
        return ResultVoUtil.error(500, "\u672a\u77e5\u9519\u8bef\uff1aEX4399");
    }
}

