/*
 * Decompiled with CFR 0.152.
 */
package com.linln.common.utils;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Random;

public class CaptchaUtil {
    private static final int WIDTH = 120;
    private static final int HEIGHT = 45;
    private static final int LENGTH = 4;
    private static final String EX_CHARS = "10ioIO";

    public static String getRandomCode() {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        int i = 0;
        while (i < 4) {
            int t = random.nextInt(123);
            if (t < 97 && (t < 65 || t > 90) && (t < 48 || t > 57) || EX_CHARS != null && EX_CHARS.indexOf((char)t) >= 0) continue;
            sb.append((char)t);
            ++i;
        }
        return sb.toString();
    }

    public static BufferedImage genCaptcha(String randomCode) {
        BufferedImage image = new BufferedImage(120, 45, 1);
        Graphics2D g = image.createGraphics();
        g.setColor(CaptchaUtil.getRandColor(200, 250));
        g.fillRect(0, 0, 120, 45);
        Random random = new Random();
        g.setColor(CaptchaUtil.getRandColor(100, 180));
        for (int i = 0; i < 30; ++i) {
            int x = random.nextInt(119);
            int y = random.nextInt(44);
            int xl = random.nextInt(60);
            int yl = random.nextInt(60);
            g.drawLine(x, y, x + xl, y + yl + 20);
        }
        float rate = 0.1f;
        int area = (int)(rate * 120.0f * 45.0f);
        for (int i = 0; i < area; ++i) {
            int x = random.nextInt(120);
            int y = random.nextInt(45);
            image.setRGB(x, y, CaptchaUtil.getRandColor(100, 200).getRGB());
        }
        int size = 41;
        Font font = new Font("Algerian", 2, size);
        g.setFont(font);
        char[] chars = randomCode.toCharArray();
        for (int i = 0; i < randomCode.length(); ++i) {
            g.drawChars(chars, i, 1, 110 / randomCode.length() * i + 5, 22 + size / 2 - 6);
        }
        g.dispose();
        return image;
    }

    private static Color getRandColor(int min, int max) {
        min = min > 255 ? 255 : min;
        max = max > 255 ? 255 : max;
        Random random = new Random();
        int r = min + random.nextInt(max - min);
        int g = min + random.nextInt(max - min);
        int b = min + random.nextInt(max - min);
        return new Color(r, g, b);
    }
}

