/*
 * Decompiled with CFR 0.152.
 */
package com.linln.common.utils;

import com.linln.common.utils.ToolUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class EncryptUtil {
    public static final String HASH_ALGORITHM_NAME = "SHA-256";
    public static final int HASH_ITERATIONS = 1024;
    private static final String CHARSET = "UTF-8";

    public static String encrypt(String password, String salt) {
        return EncryptUtil.encrypt(password, salt, HASH_ALGORITHM_NAME, 1024);
    }

    public static String encrypt(String password, String salt, String hashAlgorithmName, int hashIterations) {
        byte[] byteSalt = new byte[]{};
        byte[] bytePassword = new byte[]{};
        try {
            byteSalt = salt.getBytes(CHARSET);
            bytePassword = password.getBytes(CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(hashAlgorithmName);
            digest.reset();
            digest.update(byteSalt);
            byte[] hashed = digest.digest(bytePassword);
            for (int i = 0; i < hashIterations - 1; ++i) {
                digest.reset();
                hashed = digest.digest(hashed);
            }
            return EncryptUtil.bytesToHexString(hashed);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getRandomSalt() {
        return ToolUtil.getRandomString(6);
    }

    private static String bytesToHexString(byte[] data) {
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = digits[(0xF0 & data[i]) >>> 4];
            out[j++] = digits[0xF & data[i]];
        }
        return new String(out);
    }
}

