/*
 * Decompiled with CFR 0.152.
 */
package com.linln.common.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import javax.persistence.Id;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class EntityBeanUtil {
    private static String[] defaultFields = new String[]{"createDate", "updateDate", "createBy", "updateBy", "status"};

    public static Object[] getId(Object entity) {
        Field[] fields;
        for (Field field : fields = entity.getClass().getDeclaredFields()) {
            Id id = field.getAnnotation(Id.class);
            if (id == null) continue;
            try {
                field.setAccessible(true);
                return new Object[]{field.getName(), field.get(entity)};
            }
            catch (IllegalAccessException e) {
                throw new FatalBeanException("\u83b7\u53d6" + entity.getClass().getName() + "\u5b9e\u4f53\u5bf9\u8c61\u4e3b\u952e\u51fa\u9519\uff01", (Throwable)e);
            }
        }
        return null;
    }

    public static Object getField(Object entity, String fieldName) throws InvocationTargetException, IllegalAccessException {
        Method readMethod;
        PropertyDescriptor beanObjectPd = BeanUtils.getPropertyDescriptor(entity.getClass(), (String)fieldName);
        if (beanObjectPd != null && (readMethod = beanObjectPd.getReadMethod()) != null) {
            if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                readMethod.setAccessible(true);
            }
            return readMethod.invoke(entity, new Object[0]);
        }
        return null;
    }

    public static void setField(Object entity, String fieldName, Object value) throws InvocationTargetException, IllegalAccessException {
        Method writeMethod;
        PropertyDescriptor beanObjectPd = BeanUtils.getPropertyDescriptor(entity.getClass(), (String)fieldName);
        if (beanObjectPd != null && (writeMethod = beanObjectPd.getWriteMethod()) != null) {
            if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                writeMethod.setAccessible(true);
            }
            writeMethod.invoke(entity, value);
        }
    }

    public static void copyProperties(Object source, Object target) throws BeansException {
        EntityBeanUtil.copyProperties(source, target, null, defaultFields);
    }

    public static void copyProperties(Object source, Object target, String ... fields) throws BeansException {
        String[] jointRetainProperties = new String[defaultFields.length + fields.length];
        System.arraycopy(defaultFields, 0, jointRetainProperties, 0, defaultFields.length);
        System.arraycopy(fields, 0, jointRetainProperties, defaultFields.length, fields.length);
        EntityBeanUtil.copyProperties(source, target, null, jointRetainProperties);
    }

    private static void copyProperties(Object source, Object target, @Nullable Class<?> editable, String ... fields) throws BeansException {
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        Class<?> actualEditable = target.getClass();
        if (editable != null) {
            if (!editable.isInstance(target)) {
                throw new IllegalArgumentException("Target class [" + target.getClass().getName() + "] not assignable to Editable class [" + editable.getName() + "]");
            }
            actualEditable = editable;
        }
        PropertyDescriptor[] targetPds = BeanUtils.getPropertyDescriptors(actualEditable);
        List<String> ignoreList = fields != null ? Arrays.asList(fields) : null;
        for (PropertyDescriptor targetPd : targetPds) {
            Method readMethod;
            PropertyDescriptor sourcePd;
            Method writeMethod = targetPd.getWriteMethod();
            if (writeMethod == null || ignoreList != null && !ignoreList.contains(targetPd.getName()) || (sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || (readMethod = sourcePd.getReadMethod()) == null || !ClassUtils.isAssignable(writeMethod.getParameterTypes()[0], readMethod.getReturnType())) continue;
            try {
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                Object value = readMethod.invoke(source, new Object[0]);
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy property '" + targetPd.getName() + "' from source to target", ex);
            }
        }
    }

    public static void copyPropertiesIgnores(Object source, Object target) {
        BeanUtils.copyProperties((Object)source, (Object)target, (String[])defaultFields);
    }

    public static void copyPropertiesIgnores(Object source, Object target, String ... ignoreProperties) {
        String[] jointIgnoreProperties = new String[defaultFields.length + ignoreProperties.length];
        System.arraycopy(defaultFields, 0, jointIgnoreProperties, 0, defaultFields.length);
        System.arraycopy(ignoreProperties, 0, jointIgnoreProperties, defaultFields.length, ignoreProperties.length);
        BeanUtils.copyProperties((Object)source, (Object)target, (String[])jointIgnoreProperties);
    }

    public static Object cloneBean(Object object) {
        return EntityBeanUtil.cloneBean(object, null);
    }

    public static Object cloneBean(Object object, String ... ignoreProperties) {
        Object cloneObject = null;
        if (object != null) {
            try {
                cloneObject = object.getClass().newInstance();
                BeanUtils.copyProperties((Object)object, cloneObject, (String[])ignoreProperties);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return cloneObject;
    }
}

