/*
 * Decompiled with CFR 0.152.
 */
package com.linln.common.utils;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;

public class ToolUtil {
    public static String getRandomString(int length) {
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int range = random.nextInt(75) + 48;
            range = range < 97 ? (range < 65 ? (range > 57 ? 114 - range : range) : (range > 90 ? 180 - range : range)) : range;
            sb.append((char)range);
        }
        return sb.toString();
    }

    public static String lowerFirst(String word) {
        if (Character.isLowerCase(word.charAt(0))) {
            return word;
        }
        return String.valueOf(Character.toLowerCase(word.charAt(0))) + word.substring(1);
    }

    public static String upperFirst(String word) {
        if (Character.isUpperCase(word.charAt(0))) {
            return word;
        }
        return String.valueOf(Character.toUpperCase(word.charAt(0))) + word.substring(1);
    }

    public static String getProjectPath() {
        String filePath = ToolUtil.class.getResource("").getPath();
        String projectPath = ToolUtil.class.getClassLoader().getResource("").getPath();
        StringBuilder path = new StringBuilder();
        if (!filePath.startsWith("file:/")) {
            char[] filePathArray = filePath.toCharArray();
            char[] projectPathArray = projectPath.toCharArray();
            for (int i = 0; i < filePathArray.length && projectPathArray.length > i && filePathArray[i] == projectPathArray[i]; ++i) {
                path.append(filePathArray[i]);
            }
        } else if (!projectPath.startsWith("file:/")) {
            projectPath = projectPath.replace("/WEB-INF/classes/", "");
            projectPath = projectPath.replace("/target/classes/", "");
            try {
                path.append(URLDecoder.decode(projectPath, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                return projectPath;
            }
        } else {
            String property = System.getProperty("java.class.path");
            int firstIndex = property.lastIndexOf(System.getProperty("path.separator")) + 1;
            int lastIndex = property.lastIndexOf(File.separator) + 1;
            path.append(property, firstIndex, lastIndex);
        }
        File file = new File(path.toString());
        String rootPath = "/";
        try {
            rootPath = URLDecoder.decode(file.getAbsolutePath(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return rootPath.replaceAll("\\\\", "/");
    }

    public static String getFileSuffix(String fileName) {
        if (!fileName.isEmpty()) {
            int lastIndexOf = fileName.lastIndexOf(".");
            return fileName.substring(lastIndexOf);
        }
        return "";
    }

    public static Map<Long, String> enumToMap(Class<?> enumClass) {
        TreeMap<Long, String> map = new TreeMap<Long, String>();
        try {
            ?[] objects = enumClass.getEnumConstants();
            Method getCode = enumClass.getMethod("getCode", new Class[0]);
            Method getMessage = enumClass.getMethod("getMessage", new Class[0]);
            for (Object obj : objects) {
                Object iCode = getCode.invoke(obj, new Object[0]);
                Object iMessage = getMessage.invoke(obj, new Object[0]);
                map.put(Long.valueOf(String.valueOf(iCode)), String.valueOf(iMessage));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return map;
    }

    public static Object enumCode(Class<?> enumClass, Object code) {
        try {
            ?[] objects = enumClass.getEnumConstants();
            Method getCode = enumClass.getMethod("getCode", new Class[0]);
            for (Object obj : objects) {
                Object iCode = getCode.invoke(obj, new Object[0]);
                if (!iCode.equals(code)) continue;
                return obj;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return "";
    }
}

