/*
 * Decompiled with CFR 0.152.
 */
package com.linln.component.shiro;

import com.linln.common.constant.AdminConst;
import com.linln.common.enums.StatusEnum;
import com.linln.component.shiro.ShiroUtil;
import com.linln.modules.system.domain.Role;
import com.linln.modules.system.domain.User;
import com.linln.modules.system.service.UserService;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.SimpleCredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.codec.CodecSupport;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class AuthRealm
extends AuthorizingRealm {
    @Autowired
    private UserService userService;

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principal) {
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        User user = (User)principal.getPrimaryPrincipal();
        if (user.getId().equals(AdminConst.ADMIN_ID)) {
            info.addRole(AdminConst.ADMIN_ROLE_NAME);
            info.addStringPermission("*:*:*");
            return info;
        }
        Set<Role> roles = ShiroUtil.getSubjectRoles();
        roles.forEach(role -> {
            info.addRole(role.getName());
            role.getMenus().forEach(menu -> {
                String perms = menu.getPerms();
                if (menu.getStatus().equals(StatusEnum.OK.getCode()) && !StringUtils.isEmpty((Object)perms) && !perms.contains("*")) {
                    info.addStringPermission(perms);
                }
            });
        });
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        UsernamePasswordToken token = (UsernamePasswordToken)authenticationToken;
        User user = this.userService.getByName(token.getUsername());
        if (user == null) {
            throw new UnknownAccountException();
        }
        if (user.getStatus().equals(StatusEnum.FREEZED.getCode())) {
            throw new LockedAccountException();
        }
        ByteSource salt = ByteSource.Util.bytes((String)user.getSalt());
        return new SimpleAuthenticationInfo((Object)user, (Object)user.getPassword(), salt, this.getName());
    }

    @PostConstruct
    public void initCredentialsMatcher() {
        this.setCredentialsMatcher((CredentialsMatcher)new SimpleCredentialsMatcher(){

            public boolean doCredentialsMatch(AuthenticationToken authenticationToken, AuthenticationInfo authenticationInfo) {
                UsernamePasswordToken token = (UsernamePasswordToken)authenticationToken;
                SimpleAuthenticationInfo info = (SimpleAuthenticationInfo)authenticationInfo;
                String password = String.valueOf(token.getPassword());
                String salt = CodecSupport.toString((byte[])info.getCredentialsSalt().getBytes());
                return this.equals(ShiroUtil.encrypt(password, salt), info.getCredentials());
            }
        });
    }
}

